/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.util.Date;
import net.sourceforge.plantuml.security.SURL;

public class Version {
    private static final int MAJOR_SEPARATOR = 1000000;

    public static int version() {
        return 1202113;
    }

    public static int versionPatched() {
        if (Version.beta() != 0) {
            return Version.version() + 1;
        }
        return Version.version();
    }

    public static String versionString() {
        if (Version.beta() != 0) {
            return Version.dotted(Version.version() + 1) + "beta" + Version.beta();
        }
        return Version.dotted(Version.version());
    }

    public static String fullDescription() {
        return "PlantUML version " + Version.versionString() + " (" + Version.compileTimeString() + ")";
    }

    private static String dotted(int nb) {
        String minor = "" + nb % 1000000;
        String major = "" + nb / 1000000;
        return major + "." + minor.substring(0, 4) + "." + Integer.parseInt(minor.substring(4));
    }

    public static String versionString(int size) {
        StringBuilder sb = new StringBuilder(Version.versionString());
        while (sb.length() < size) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static int beta() {
        boolean beta = false;
        return 0;
    }

    public static String etag() {
        return Integer.toString(Version.version() % 1000000 - 201670, 36) + Integer.toString(Version.beta(), 36);
    }

    public static String turningId() {
        return Version.etag();
    }

    public static long compileTime() {
        return 1635766725930L;
    }

    public static String compileTimeString() {
        if (Version.beta() != 0) {
            return "Unknown compile time";
        }
        return new Date(Version.compileTime()).toString();
    }

    public static String getJarPath() {
        try {
            ClassLoader loader = Version.class.getClassLoader();
            if (loader == null) {
                return "No ClassLoader?";
            }
            SURL url = SURL.create(loader.getResource("net/sourceforge/plantuml/version/Version.class"));
            if (url == null) {
                return "No URL?";
            }
            String fullpath = url.toString();
            fullpath = fullpath.replaceAll("net/sourceforge/plantuml/version/Version\\.class", "");
            return fullpath;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }
}

