/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.HtmlFile;
import nl.talsmasoftware.umldoclet.html.Postprocessor;
import nl.talsmasoftware.umldoclet.util.FileUtils;

final class ClassDiagramInserter
extends DiagramFile {
    private final String extension;
    private final String pathToCompare;

    ClassDiagramInserter(File basedir, File diagramFile, boolean hasImagesDirectory) {
        super(basedir, diagramFile);
        String fileName = diagramFile.getName();
        int dotIdx = fileName.lastIndexOf(46);
        this.extension = fileName.substring(dotIdx);
        this.pathToCompare = hasImagesDirectory ? fileName.substring(0, dotIdx).replace('.', '/') + this.extension : FileUtils.relativePath(this.basedir, this.diagramFile);
    }

    private String changeHtmlFileNameExtension(Object htmlFileName) {
        return htmlFileName.toString().replaceFirst("\\.html$", this.extension);
    }

    @Override
    boolean matches(HtmlFile html) {
        return this.pathToCompare.equals(this.changeHtmlFileNameExtension(FileUtils.relativePath(this.basedir, html.path.toFile())));
    }

    @Override
    public Postprocessor.Inserter newInserter(String relativePathToDiagram) {
        return new Inserter(relativePathToDiagram);
    }

    private final class Inserter
    extends Postprocessor.Inserter {
        private boolean wrappingAddedToPre;
        private boolean clearRightAdded;

        private Inserter(String relativePath) {
            super(relativePath);
            this.wrappingAddedToPre = false;
            this.clearRightAdded = false;
        }

        @Override
        String process(String line) {
            if (!this.inserted) {
                int idx = line.indexOf("<hr>");
                if (idx >= 0) {
                    this.inserted = true;
                    return line.substring(0, idx += 4) + System.lineSeparator() + this.getImageTag() + line.substring(idx);
                }
            } else if (!this.clearRightAdded) {
                int idx;
                if (!this.wrappingAddedToPre && (idx = line.indexOf("<pre>")) >= 0) {
                    this.wrappingAddedToPre = true;
                    return line.substring(0, idx) + "<pre style=\"white-space:pre-wrap;\">" + line.substring(idx + 5);
                }
                String cleared = this.addClearRightStyle(line);
                if (cleared != null) {
                    this.clearRightAdded = true;
                    return cleared;
                }
            }
            return line;
        }

        private String getImageTag() {
            String style = " style=\"max-width:60%;float:right;\"";
            if (this.relativePath.endsWith(".svg")) {
                return "<object type=\"image/svg+xml\" data=\"" + this.relativePath + "\" " + style + "></object>";
            }
            return "<img src=\"" + this.relativePath + "\" alt=\"" + this.getDiagramName() + " UML Diagram\"" + style + "/>";
        }

        private String addClearRightStyle(String line) {
            String summaryDiv = "<div class=\"summary\"";
            int idx = line.indexOf("<div class=\"summary\"");
            if (idx < 0) {
                return null;
            }
            int ins = idx + "<div class=\"summary\"".length();
            return line.substring(0, ins) + " style=\"clear:right;\"" + line.substring(ins);
        }

        private String getDiagramName() {
            String name = this.relativePath.substring(this.relativePath.lastIndexOf(47) + 1);
            int dotIdx = name.lastIndexOf(46);
            if (dotIdx > 0) {
                name = name.substring(0, dotIdx);
            }
            return name;
        }
    }
}

