/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import com.sun.source.util.DocTreePath;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import nl.talsmasoftware.umldoclet.javadoc.DocletConfig;
import nl.talsmasoftware.umldoclet.logging.Logger;
import nl.talsmasoftware.umldoclet.logging.Message;

final class LocalizedReporter
implements Reporter,
Logger {
    private final DocletConfig config;
    private final Reporter delegate;
    private final Locale locale;

    LocalizedReporter(DocletConfig config, Reporter delegate, Locale locale) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
        this.delegate = delegate;
        this.locale = locale;
    }

    @Override
    public void debug(Object key, Object ... args) {
        this.log(Diagnostic.Kind.OTHER, key, args);
    }

    @Override
    public void info(Message key, Object ... args) {
        this.log(Diagnostic.Kind.NOTE, (Object)key, args);
    }

    @Override
    public void warn(Message key, Object ... args) {
        this.log(Diagnostic.Kind.WARNING, (Object)key, args);
    }

    @Override
    public void error(Message key, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, (Object)key, args);
    }

    private void log(Diagnostic.Kind kind, Object key, Object ... args) {
        if (this.mustPrint(kind)) {
            this.doPrint(kind, key instanceof Message ? this.localize((Message)((Object)key), args) : MessageFormat.format(Objects.toString(key), this.localizeArgs(args)));
        }
    }

    @Override
    public String localize(Message key, Object ... args) {
        String message = key.toString(this.locale);
        if (args.length > 0) {
            message = MessageFormat.format(message, this.localizeArgs(args));
        }
        return message;
    }

    private Object[] localizeArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Message)) continue;
            args[i] = ((Message)((Object)args[i])).toString(this.locale);
        }
        return args;
    }

    private boolean mustPrint(Diagnostic.Kind kind) {
        Diagnostic.Kind threshold = this.config.quiet ? Diagnostic.Kind.WARNING : (this.config.verbose ? Diagnostic.Kind.OTHER : Diagnostic.Kind.NOTE);
        return kind != null && kind.compareTo(threshold) <= 0;
    }

    @Override
    public void print(Diagnostic.Kind kind, String msg) {
        if (this.mustPrint(kind)) {
            this.doPrint(kind, msg);
        }
    }

    @Override
    public void print(Diagnostic.Kind kind, DocTreePath path, String msg) {
        if (this.mustPrint(kind)) {
            this.doPrint(kind, path, msg);
        }
    }

    @Override
    public void print(Diagnostic.Kind kind, Element elem, String msg) {
        if (this.mustPrint(kind)) {
            this.doPrint(kind, elem, msg);
        }
    }

    private void doPrint(Diagnostic.Kind kind, String msg) {
        if (this.delegate == null) {
            System.out.println(msg);
        } else {
            this.delegate.print(kind, msg);
        }
    }

    private void doPrint(Diagnostic.Kind kind, DocTreePath path, String msg) {
        if (this.delegate == null) {
            System.out.println(msg);
        } else {
            this.delegate.print(kind, path, msg);
        }
    }

    private void doPrint(Diagnostic.Kind kind, Element elem, String msg) {
        if (this.delegate == null) {
            System.out.println(msg);
        } else {
            this.delegate.print(kind, elem, msg);
        }
    }
}

