/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc.dependencies;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner9;
import jdk.javadoc.doclet.DocletEnvironment;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageDependency;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageElementVisitor;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageTypeVisitor;
import nl.talsmasoftware.umldoclet.logging.Message;

public class DependenciesElementScanner
extends ElementScanner9<Set<PackageDependency>, String> {
    private final DocletEnvironment docEnv;
    private final Configuration config;

    public DependenciesElementScanner(DocletEnvironment docEnv, Configuration config) {
        super(new LinkedHashSet());
        this.docEnv = Objects.requireNonNull(docEnv, "Doclet environemnt is <null>");
        this.config = Objects.requireNonNull(config, "Configuration is <null>");
    }

    @Override
    public Set<PackageDependency> visitPackage(PackageElement visitedPackage, String fromPackage) {
        boolean included = this.docEnv.isIncluded(visitedPackage);
        String packageName = visitedPackage.getQualifiedName().toString();
        if (!included) {
            this.config.logger().debug((Object)Message.DEBUG_PACKAGE_VISITED_BUT_UNDOCUMENTED, packageName);
            return (Set)this.DEFAULT_VALUE;
        }
        return (Set)super.visitPackage(visitedPackage, packageName);
    }

    @Override
    public Set<PackageDependency> visitType(TypeElement visitedType, String fromPackage) {
        String pkg = fromPackage == null && this.docEnv.isIncluded(visitedType) ? (String)PackageElementVisitor.INSTANCE.visit(visitedType) : fromPackage;
        this.addDependency(pkg, visitedType.getSuperclass());
        visitedType.getInterfaces().forEach(implemented -> this.addDependency(pkg, (TypeMirror)implemented));
        return (Set)super.visitType(visitedType, pkg);
    }

    @Override
    public Set<PackageDependency> visitVariable(VariableElement visitedVariable, String fromPackage) {
        this.addDependency(fromPackage, visitedVariable.asType());
        return (Set)super.visitVariable(visitedVariable, fromPackage);
    }

    @Override
    public Set<PackageDependency> visitExecutable(ExecutableElement visitedExecutable, String fromPackage) {
        this.addDependency(fromPackage, visitedExecutable.getReturnType());
        visitedExecutable.getThrownTypes().forEach(thrownType -> this.addDependency(fromPackage, (TypeMirror)thrownType));
        return (Set)super.visitExecutable(visitedExecutable, fromPackage);
    }

    @Override
    public Set<PackageDependency> visitTypeParameter(TypeParameterElement visitedTypeParameter, String fromPackage) {
        this.addDependency(fromPackage, visitedTypeParameter.getGenericElement());
        visitedTypeParameter.getBounds().forEach(bound -> this.addDependency(fromPackage, (TypeMirror)bound));
        return (Set)super.visitTypeParameter(visitedTypeParameter, fromPackage);
    }

    @Override
    public Set<PackageDependency> visitUnknown(Element visitedUnknown, String fromPackage) {
        return (Set)this.DEFAULT_VALUE;
    }

    private void addDependency(String fromPackage, TypeMirror toType) {
        String toPackage = (String)PackageTypeVisitor.INSTANCE.visit(toType);
        this.addDependency(fromPackage, toPackage);
    }

    private void addDependency(String fromPackage, Element toElement) {
        String toPackage = (String)PackageElementVisitor.INSTANCE.visit(toElement);
        this.addDependency(fromPackage, toPackage);
    }

    private void addDependency(String fromPackage, String toPackage) {
        if (fromPackage != null && toPackage != null && !fromPackage.equals(toPackage)) {
            ((Set)this.DEFAULT_VALUE).add(new PackageDependency(fromPackage, toPackage));
        }
    }
}

