/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Diagram;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class ClassDiagram
extends Diagram {
    private File pumlFile = null;

    public ClassDiagram(Configuration config, Type type) {
        super(config);
        this.addChild(type);
    }

    public Type getType() {
        return this.getChildren().stream().filter(Type.class::isInstance).map(Type.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("No Type defined in Class diagram!"));
    }

    @Override
    public void addChild(UMLNode child) {
        super.addChild(child);
        if (child instanceof Type) {
            ((Type)child).setIncludePackagename(true);
        }
    }

    @Override
    protected <IPW extends IndentingPrintWriter> IPW writeChildrenTo(IPW output) {
        output.append("set namespaceSeparator none").newline().append("hide empty fields").newline().append("hide empty methods").newline().newline();
        return super.writeChildrenTo(output);
    }

    @Override
    protected File getPlantUmlFile() {
        if (this.pumlFile == null) {
            Type type = this.getType();
            StringBuilder result = new StringBuilder(this.getConfiguration().destinationDirectory());
            if (result.length() > 0 && result.charAt(result.length() - 1) != '/') {
                result.append('/');
            }
            String containingPackage = type.getPackagename();
            result.append(containingPackage.replace('.', '/')).append('/');
            if (type.getName().qualified.startsWith(containingPackage + ".")) {
                result.append(type.getName().qualified.substring(containingPackage.length() + 1));
            } else {
                result.append(type.getName().simple);
            }
            this.pumlFile = new File(result.append(".puml").toString());
        }
        return this.pumlFile;
    }
}

