/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public final class UriUtils {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UriUtils() {
        throw new UnsupportedOperationException();
    }

    public static URI addPathComponent(URI uri, String component) {
        if (uri != null && component != null) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), Optional.ofNullable(uri.getPath()).map(path -> UriUtils.join(path, component, '/')).orElse(component), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("Could not add path component \"" + component + "\" to " + uri + ": " + use.getMessage(), use);
            }
        }
        return uri;
    }

    public static URI addHttpParam(URI uri, String name, String value) {
        if (uri != null && name != null && value != null && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
            String base;
            int queryIdx = (base = uri.toASCIIString()).indexOf(63);
            int fragmentIdx = base.indexOf(35, queryIdx < 0 ? 0 : queryIdx);
            StringBuilder newUri = new StringBuilder(fragmentIdx >= 0 ? base.substring(0, fragmentIdx) : base);
            newUri.append(queryIdx < 0 ? (char)'?' : '&');
            UriUtils.appendEncoded(newUri, name);
            newUri.append('=');
            UriUtils.appendEncoded(newUri, value);
            if (fragmentIdx >= 0) {
                newUri.append(base, fragmentIdx, base.length());
            }
            return URI.create(newUri.toString());
        }
        return uri;
    }

    private static void appendEncoded(StringBuilder sb, String value) {
        for (char ch : value.toCharArray()) {
            if (UriUtils.isUnreserved(ch)) {
                sb.append(ch);
                continue;
            }
            UriUtils.appendEscapedByte(sb, (byte)ch);
        }
    }

    private static String join(String left, String right, char separator) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        String sep = "" + separator;
        return left.endsWith(sep) || right.startsWith(sep) ? left + right : left + separator + right;
    }

    private static boolean isUnreserved(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '-' || ch == '.' || ch == '_' || ch == '~';
    }

    private static void appendEscapedByte(StringBuilder builder, byte value) {
        builder.append('%');
        builder.append(HEX[value >> 4 & 0xF]);
        builder.append(HEX[value & 0xF]);
    }
}

