/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2023, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;

public abstract class AbstractTile extends CommonTile implements Tile {

	public AbstractTile(StringBounder stringBounder, YGauge currentY) {
		super(stringBounder);
		if (YGauge.USE_ME)
			System.err.println("CREATING " + getClass());
	}

	public AbstractTile(StringBounder stringBounder) {
		super(stringBounder);
	}

	@Override
	public YGauge getYGauge() {
		throw new UnsupportedOperationException(getClass().toString());
	}

	public double getContactPointRelative() {
		return -1;
	}

	final public double getZZZ() {
		final double result = getPreferredHeight() - getContactPointRelative();
		assert result >= 0;
		return result;
	}

	public boolean matchAnchor(String anchor) {
		final Event event = this.getEvent();
		if (event instanceof AbstractMessage) {
			final AbstractMessage msg = (AbstractMessage) event;
			if (anchor.equals(msg.getAnchor()))
				return true;

		}
		return false;
	}

}
