/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2023, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Stairs {

	private final List<Step> values = new ArrayList<>();

	public void addStep(Step step) {
		if (step.getIndent() < 0) {
			throw new IllegalArgumentException();
		}
		if (values.size() > 0) {
			final double lastY = values.get(values.size() - 1).getValue();
			if (step.getValue() <= lastY) {
				// throw new IllegalArgumentException();
				return;
			}
		}
		values.add(step);
	}

	public int getMaxIndent() {
		int max = Integer.MIN_VALUE;
		for (Step step : values) {
			final int v = step.getIndent();
			if (v > max) {
				max = v;
			}
		}
		return max;
	}

	public Collection<Step> getSteps() {
		return Collections.unmodifiableCollection(values);
	}

}
