/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.CenteredText;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.LaneDivider;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.TextBlockInterceptorUDrawable;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddUrl;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateParallel;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorSwitch;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.SlotFinder;
import net.sourceforge.plantuml.utils.MathUtils;

public class Swimlanes
extends AbstractTextBlock
implements TextBlock,
Styleable {
    private final ISkinParam skinParam;
    private final Pragma pragma;
    private final List<Swimlane> swimlanesRaw = new ArrayList<Swimlane>();
    private final List<Swimlane> swimlanesSpecial = new ArrayList<Swimlane>();
    private final List<LaneDivider> dividers = new ArrayList<LaneDivider>();
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = InstructionList.empty();
    private LinkRendering nextLinkRenderer = LinkRendering.none();
    private Style style;
    private MinMax cachedMinMax;

    private List<Swimlane> swimlanes() {
        return Collections.unmodifiableList(this.swimlanesRaw);
    }

    private List<Swimlane> swimlanesSpecial() {
        if (this.swimlanesSpecial.size() == 0) {
            this.swimlanesSpecial.addAll(this.swimlanesRaw);
            Swimlane last = new Swimlane("");
            last.setMinMax(MinMax.getEmpty(true));
            this.swimlanesSpecial.add(last);
        }
        return Collections.unmodifiableList(this.swimlanesSpecial);
    }

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.swimlane);
    }

    public Swimlanes(ISkinParam skinParam, Pragma pragma) {
        this.skinParam = skinParam;
        this.pragma = pragma;
    }

    protected Style getStyle() {
        if (this.style == null) {
            this.style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return this.style;
    }

    private FtileFactory getFtileFactory(StringBounder stringBounder) {
        FtileFactory factory = new VCompactFactory(this.skinParam, stringBounder);
        factory = new FtileFactoryDelegatorAddUrl(factory);
        factory = new FtileFactoryDelegatorAssembly(factory);
        factory = new FtileFactoryDelegatorIf(factory, this.pragma);
        factory = new FtileFactoryDelegatorSwitch(factory);
        factory = new FtileFactoryDelegatorWhile(factory);
        factory = new FtileFactoryDelegatorRepeat(factory);
        factory = new FtileFactoryDelegatorCreateParallel(factory);
        factory = new FtileFactoryDelegatorAddNote(factory);
        factory = new FtileFactoryDelegatorCreateGroup(factory);
        return factory;
    }

    public void swimlane(String name, HColor color, Display label) {
        this.currentSwimlane = this.getOrCreate(name);
        if (color != null) {
            this.currentSwimlane.setSpecificColorTOBEREMOVED(ColorType.BACK, color);
        }
        if (!Display.isNull(label)) {
            this.currentSwimlane.setDisplay(label);
        }
    }

    private Swimlane getOrCreate(String name) {
        for (Swimlane s : this.swimlanes()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        Swimlane result = new Swimlane(name);
        this.swimlanesRaw.add(result);
        return result;
    }

    public final void computeSize(StringBounder stringBounder) {
        SlotFinder ug = SlotFinder.create(CompressionMode.ON_Y, stringBounder);
        if (this.swimlanes().size() > 1) {
            Ftile full = this.root.createFtile(this.getFtileFactory(stringBounder));
            this.computeSizeInternal(ug, full);
        }
    }

    @Override
    public final void drawU(UGraphic ug) {
        TextBlock full = this.root.createFtile(this.getFtileFactory(ug.getStringBounder()));
        ug = new UGraphicForSnake(ug);
        if (this.swimlanes().size() > 1) {
            this.drawWhenSwimlanes(ug, full);
        } else {
            full = new TextBlockInterceptorUDrawable(full);
            full.drawU(ug);
            ug.flushUg();
        }
    }

    private void drawGtile(UGraphic ug) {
        TextBlock full = this.root.createGtile(this.skinParam, ug.getStringBounder());
        ug = new UGraphicForSnake(ug);
        if (this.swimlanes().size() > 1) {
            this.drawWhenSwimlanes(ug, full);
        } else {
            full = new TextBlockInterceptorUDrawable(full);
            full.drawU(ug);
            ug.flushUg();
        }
    }

    private TextBlock getTitle(Swimlane swimlane) {
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        FontConfiguration fontConfiguration = this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet());
        LineBreakStrategy wrap = this.getWrap();
        if (wrap.isAuto()) {
            wrap = new LineBreakStrategy("" + (int)swimlane.getActualWidth());
        }
        return swimlane.getDisplay().create9(fontConfiguration, horizontalAlignment, this.skinParam, wrap);
    }

    private LineBreakStrategy getWrap() {
        LineBreakStrategy wrap = this.skinParam.swimlaneWrapTitleWidth();
        if (wrap == LineBreakStrategy.NONE) {
            wrap = this.skinParam.wrapWidth();
        }
        return wrap;
    }

    private UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        double titlesHeight = this.getTitlesHeight(stringBounder);
        return UTranslate.dy(titlesHeight > 0.0 ? titlesHeight + 5.0 : 0.0);
    }

    private double getTitlesHeight(StringBounder stringBounder) {
        double titlesHeight = 0.0;
        for (Swimlane swimlane : this.swimlanes()) {
            TextBlock swTitle = this.getTitle(swimlane);
            titlesHeight = Math.max(titlesHeight, swTitle.calculateDimension(stringBounder).getHeight());
        }
        return titlesHeight;
    }

    private void drawWhenSwimlanes(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        UTranslate titleHeightTranslate = this.getTitleHeightTranslate(stringBounder);
        this.drawTitlesBackground(ug);
        XDimension2D dimensionFull = full.calculateDimension(stringBounder);
        int i = 0;
        assert (this.dividers.size() == this.swimlanes().size() + 1);
        for (Swimlane swimlane : this.swimlanesSpecial()) {
            LaneDivider divider1 = this.dividers.get(i);
            double xpos = swimlane.getTranslate().getDx() + swimlane.getMinMax().getMinX();
            HColor back = swimlane.getColors().getColor(ColorType.BACK);
            if (back != null && !back.isTransparent()) {
                LaneDivider divider2 = this.dividers.get(i + 1);
                UGraphic background = ug.apply(back.bg()).apply(back).apply(UTranslate.dx(xpos - divider1.getX2()));
                double width = swimlane.getActualWidth() + divider1.getX2() + divider2.getX1();
                double height = dimensionFull.getHeight() + titleHeightTranslate.getDy();
                background.draw(new URectangle(width, height).ignoreForCompressionOnX().ignoreForCompressionOnY());
            }
            full.drawU(new UGraphicInterceptorOneSwimlane(ug, swimlane, this.swimlanes()).apply(swimlane.getTranslate()).apply(this.getTitleHeightTranslate(stringBounder)));
            double dividerWith = divider1.calculateDimension(stringBounder).getWidth();
            divider1.drawU(ug.apply(UTranslate.dx(xpos - dividerWith)));
            ++i;
        }
        Cross cross = new Cross(ug.apply(this.getTitleHeightTranslate(stringBounder)));
        full.drawU(cross);
        cross.flushUg();
        this.drawTitles(ug);
    }

    private void drawTitlesBackground(UGraphic ug) {
        HColor color = this.getStyle().value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        if (color != null) {
            double titleHeight = this.getTitlesHeight(ug.getStringBounder());
            double fullWidth = this.swimlanesSpecial().get(this.swimlanesSpecial().size() - 1).getTranslate().getDx() - 10.0 - 1.0;
            URectangle back = new URectangle(fullWidth, titleHeight).ignoreForCompressionOnX().ignoreForCompressionOnY();
            ug.apply(UTranslate.dx(5.0)).apply(color.bg()).apply(color).draw(back);
        }
    }

    private void drawTitles(UGraphic ug) {
        for (Swimlane swimlane : this.swimlanes()) {
            TextBlock swTitle = this.getTitle(swimlane);
            double x2 = swimlane.getTranslate().getDx() + swimlane.getMinMax().getMinX();
            CenteredText centeredText = new CenteredText(swTitle, this.getWidthWithoutTitle(swimlane));
            ug.apply(UTranslate.dx(x2)).draw(centeredText);
        }
    }

    private void computeDrawingWidths(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Swimlane swimlane : this.swimlanes()) {
            LimitFinder limitFinder = LimitFinder.create(stringBounder, false);
            UGraphicInterceptorOneSwimlane interceptor = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane, this.swimlanes());
            full.drawU(interceptor);
            interceptor.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            swimlane.setMinMax(minMax);
        }
    }

    private void computeSizeInternal(UGraphic ug, TextBlock full) {
        this.computeDrawingWidths(ug, full);
        double min = this.skinParam.swimlaneWidth();
        if (min == -1.0) {
            for (Swimlane swimlane : this.swimlanes()) {
                min = Math.max(min, this.getWidthWithoutTitle(swimlane));
            }
        }
        StringBounder stringBounder = ug.getStringBounder();
        for (int i = 0; i < this.swimlanesSpecial().size(); ++i) {
            Swimlane swimlane = this.swimlanesSpecial().get(i);
            double swimlaneActualWidth = MathUtils.max(min, this.getWidthWithoutTitle(swimlane));
            swimlane.setWidth(swimlaneActualWidth);
        }
        UTranslate titleHeightTranslate = this.getTitleHeightTranslate(stringBounder);
        XDimension2D dimensionFull = full.calculateDimension(stringBounder);
        this.dividers.clear();
        double xpos = 0.0;
        for (int i = 0; i < this.swimlanesSpecial().size(); ++i) {
            Swimlane swimlane = this.swimlanesSpecial().get(i);
            double x1 = this.getHalfMissingSpace(stringBounder, i, min);
            double x2 = this.getHalfMissingSpace(stringBounder, i + 1, min);
            LaneDivider laneDivider = new LaneDivider(this.skinParam, x1, x2, dimensionFull.getHeight() + titleHeightTranslate.getDy());
            this.dividers.add(laneDivider);
            double xx = xpos + laneDivider.getWidth() - swimlane.getMinMax().getMinX() + (swimlane.getActualWidth() - this.getWidthWithoutTitle(swimlane)) / 2.0;
            swimlane.setTranslate(UTranslate.dx(xx));
            xpos += swimlane.getActualWidth() + laneDivider.getWidth();
        }
        assert (this.dividers.size() == this.swimlanes().size() + 1);
    }

    public double getHalfMissingSpace(StringBounder stringBounder, int i, double min) {
        if (i == 0 || i > this.swimlanesSpecial().size()) {
            return 5.0;
        }
        Swimlane swimlane = this.swimlanesSpecial().get(i - 1);
        double swimlaneActualWidth = Math.max(min, this.getWidthWithoutTitle(swimlane));
        double titleWidth = this.getTitle(swimlane).calculateDimension(stringBounder).getWidth();
        if (titleWidth <= swimlaneActualWidth) {
            return 5.0;
        }
        assert (titleWidth > swimlaneActualWidth);
        return Math.max(5.0, 5.0 + (titleWidth - swimlaneActualWidth) / 2.0);
    }

    private double getWidthWithoutTitle(Swimlane swimlane) {
        return swimlane.getMinMax().getWidth();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMinMax(stringBounder).getDimension();
    }

    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    public void setCurrent(Instruction current) {
        this.currentInstruction = current;
    }

    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    public void setNextLinkRenderer(LinkRendering link) {
        this.nextLinkRenderer = Objects.requireNonNull(link);
    }

    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder, false);
        }
        return this.cachedMinMax;
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic ug) {
            super(ug);
        }

        @Override
        public void draw(UShape shape) {
            if (shape instanceof Ftile) {
                Ftile tile = (Ftile)shape;
                tile.drawU(this);
            } else if (shape instanceof Connection) {
                Connection connection = (Connection)shape;
                Ftile tile1 = connection.getFtile1();
                Ftile tile2 = connection.getFtile2();
                if (tile1 == null || tile2 == null) {
                    return;
                }
                if (tile1.getSwimlaneOut() != tile2.getSwimlaneIn()) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            } else if (shape instanceof Gtile) {
                Gtile tile = (Gtile)shape;
                tile.drawU(this);
            } else if (shape instanceof GConnection) {
                GConnection connection = (GConnection)shape;
                System.err.println("CROSS IN SWIMLANES");
                connection.drawTranslatable(this.getUg());
            }
        }

        @Override
        public UGraphic apply(UChange change) {
            return new Cross(this.getUg().apply(change));
        }
    }
}

