/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondSquare;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

class FtileWhile
extends AbstractFtile {
    private final Ftile whileBlock;
    private final Ftile diamond1;
    private final Ftile specialOut;
    private final Ftile backward;

    @Override
    public Collection<Ftile> getMyChildren() {
        if (this.specialOut == null) {
            return Arrays.asList(this.whileBlock, this.diamond1);
        }
        return Arrays.asList(this.whileBlock, this.diamond1, this.specialOut);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>(this.whileBlock.getSwimlanes());
        result.add(this.getSwimlaneIn());
        return result;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile(Ftile whileBlock, Ftile diamond1, Ftile specialOut, Ftile backward) {
        super(whileBlock.skinParam());
        this.whileBlock = whileBlock;
        this.diamond1 = diamond1;
        this.specialOut = specialOut;
        this.backward = backward;
    }

    public static Ftile create(LinkRendering outColor, Swimlane swimlane, Ftile whileBlock, Display test, HColor borderColor, HColor backColor, Rainbow arrowColor, Display yes, FontConfiguration fontArrow, FtileFactory ftileFactory, ConditionStyle conditionStyle, FontConfiguration fcTest, Instruction specialOut, Ftile backward, LinkRendering incoming1, LinkRendering incoming2) {
        FtileDiamondWIP diamond1;
        TextBlock yesTb = yes.create(fontArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        TextBlock testTb = test.isWhite() ? TextBlockUtils.empty(0.0, 0.0) : test.create(fcTest, whileBlock.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), ftileFactory.skinParam());
        TextBlock outTb = outColor.getDisplay().create(fontArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        if (conditionStyle == ConditionStyle.INSIDE_HEXAGON) {
            diamond1 = new FtileDiamondInside(testTb, whileBlock.skinParam(), backColor, borderColor, swimlane).withNorth(yesTb).withWest(outTb);
        } else if (conditionStyle == ConditionStyle.INSIDE_DIAMOND) {
            diamond1 = new FtileDiamondSquare(testTb, whileBlock.skinParam(), backColor, borderColor, swimlane).withNorth(yesTb).withWest(outTb);
        } else if (conditionStyle == ConditionStyle.EMPTY_DIAMOND) {
            diamond1 = new FtileDiamond(whileBlock.skinParam(), backColor, borderColor, swimlane).withNorth(testTb).withSouth(yesTb).withWest(outTb);
        } else {
            throw new IllegalStateException();
        }
        Ftile special = specialOut == null ? null : specialOut.createFtile(ftileFactory);
        FtileWhile result = new FtileWhile(whileBlock, diamond1, special, backward);
        FtileGeometry dim = whileBlock.calculateDimension(ftileFactory.getStringBounder());
        TextBlock back1 = incoming1.getDisplay().create(fontArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        ArrayList<Connection> conns = new ArrayList<Connection>();
        if (((XDimension2D)dim).getWidth() == 0.0 || ((XDimension2D)dim).getHeight() == 0.0) {
            FtileWhile ftileWhile = result;
            Objects.requireNonNull(ftileWhile);
            conns.add(ftileWhile.new ConnectionBackEmpty(incoming1.getRainbow()));
        } else {
            FtileWhile ftileWhile = result;
            Objects.requireNonNull(ftileWhile);
            conns.add(ftileWhile.new ConnectionIn(whileBlock.getInLinkRendering().getRainbow(arrowColor)));
            if (backward == null) {
                FtileWhile ftileWhile2 = result;
                Objects.requireNonNull(ftileWhile2);
                conns.add(ftileWhile2.new ConnectionBackSimple(incoming1.getRainbow(), back1));
            } else {
                TextBlock back2 = incoming2.getDisplay().create(fontArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
                FtileWhile ftileWhile3 = result;
                Objects.requireNonNull(ftileWhile3);
                conns.add(ftileWhile3.new ConnectionBackBackward1(incoming1.getRainbow(), back1));
                FtileWhile ftileWhile4 = result;
                Objects.requireNonNull(ftileWhile4);
                conns.add(ftileWhile4.new ConnectionBackBackward2(incoming2.getRainbow(), back2));
            }
        }
        if (specialOut == null) {
            FtileWhile ftileWhile = result;
            Objects.requireNonNull(ftileWhile);
            conns.add(ftileWhile.new ConnectionOut(outColor.getRainbow()));
        } else {
            FtileWhile ftileWhile = result;
            Objects.requireNonNull(ftileWhile);
            conns.add(ftileWhile.new ConnectionOutSpecial(outColor.getRainbow()));
        }
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateForWhile(stringBounder)).draw(this.whileBlock);
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        if (this.specialOut != null) {
            ug.apply(this.getTranslateForSpecial(stringBounder)).draw(this.specialOut);
        }
        if (this.backward != null) {
            ug.apply(this.getTranslateBackward(stringBounder)).draw(this.backward);
        }
    }

    private UTranslate getTranslateBackward(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionFtile(stringBounder);
        FtileGeometry dimBackward = this.backward.calculateDimension(stringBounder);
        double x = ((XDimension2D)dimTotal).getWidth() - ((XDimension2D)dimBackward).getWidth();
        double y = (((XDimension2D)dimTotal).getHeight() - ((XDimension2D)dimBackward).getHeight()) / 2.0;
        return new UTranslate(x, y);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry geoDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry geoWhile = this.whileBlock.calculateDimension(stringBounder);
        double diff = -geoWhile.getWidth();
        if (diff > 0.0) {
            geoWhile = geoWhile.addMarginX(diff / 2.0);
            assert (false);
        }
        FtileGeometry geo = geoDiamond1.appendBottom(geoWhile);
        double height = geo.getHeight() + 48.0;
        double dx = 24.0;
        double backwardWidth = 0.0;
        if (this.backward != null) {
            backwardWidth += this.backward.calculateDimension(stringBounder).getWidth();
        }
        return new FtileGeometry(this.xDeltaBecauseSpecial(stringBounder) + geo.getWidth() + 24.0 + 12.0 + backwardWidth, height, this.xDeltaBecauseSpecial(stringBounder) + geo.getLeft() + 24.0, geoDiamond1.getInY(), height);
    }

    private double xDeltaBecauseSpecial(StringBounder stringBounder) {
        if (this.specialOut == null) {
            return 0.0;
        }
        return this.specialOut.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.whileBlock) {
            return this.getTranslateForWhile(stringBounder);
        }
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForWhile(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimWhile = this.whileBlock.calculateDimension(stringBounder);
        double y = dimDiamond1.getHeight() + (dimTotal.getHeight() - dimDiamond1.getHeight() - dimWhile.getHeight()) / 2.0;
        double x = dimTotal.getLeft() - dimWhile.getLeft();
        return new UTranslate(x, y);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double y1 = 0.0;
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    private UTranslate getTranslateForSpecial(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
        double y1 = Math.max(3.0 * half, 48.0);
        double xWhile = this.getTranslateForWhile(stringBounder).getDx() - 12.0;
        double xDiamond = this.getTranslateDiamond1(stringBounder).getDx();
        double x1 = Math.min(xWhile, xDiamond) - this.xDeltaBecauseSpecial(stringBounder);
        return new UTranslate(x1, y1);
    }

    class ConnectionBackEmpty
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionBackEmpty(Rainbow endInlinkColor) {
            super(FtileWhile.this.diamond1, FtileWhile.this.diamond1);
            this.endInlinkColor = endInlinkColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(FtileWhile.this.diamond1.calculateDimension(stringBounder).getPointOut());
        }

        private double getBottom(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateForWhile(stringBounder).getDy() + geo.getHeight();
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.endInlinkColor, Arrows.asToLeft()).emphasizeDirection(Direction.UP);
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y2 = p2.getY() + dimDiamond1.getInY() + half;
            snake.addPoint(x1, y1);
            double y1bis = Math.max(y1, this.getBottom(stringBounder)) + 12.0;
            snake.addPoint(x1, y1bis);
            double xx = ((XDimension2D)dimTotal).getWidth();
            snake.addPoint(xx, y1bis);
            snake.addPoint(xx, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1bis)).draw(new UEmpty(5.0, 12.0));
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow arrowColor) {
            super(FtileWhile.this.diamond1, FtileWhile.this.whileBlock);
            this.arrowColor = arrowColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.arrowColor, Arrows.asToDown()).withMerge(MergeStrategy.LIMITED);
            XPoint2D mp1a = translate1.getTranslated(p1);
            XPoint2D mp2b = translate2.getTranslated(p2);
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionBackSimple
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow endInlinkColor;
        private final TextBlock back;

        public ConnectionBackSimple(Rainbow endInlinkColor, TextBlock back) {
            super(FtileWhile.this.whileBlock, FtileWhile.this.diamond1);
            this.endInlinkColor = endInlinkColor;
            this.back = back;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(geo.getPointOut());
        }

        private double getBottom(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateForWhile(stringBounder).getDy() + geo.getHeight();
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            XPoint2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y2 = p2.getY() + dimDiamond1.getInY() + half;
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.endInlinkColor, Arrows.asToLeft()).emphasizeDirection(Direction.UP).withLabel(this.back, this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            double y1bis = Math.max(y1, this.getBottom(stringBounder)) + 12.0;
            snake.addPoint(x1, y1bis);
            double xx = ((XDimension2D)dimTotal).getWidth();
            snake.addPoint(xx, y1bis);
            snake.addPoint(xx, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1bis)).draw(new UEmpty(5.0, 12.0));
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.endInlinkColor, Arrows.asToLeft()).withMerge(MergeStrategy.LIMITED);
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            XPoint2D ap1 = this.getP1(stringBounder);
            XPoint2D ap2 = this.getP2(stringBounder);
            XPoint2D p1 = translate1.getTranslated(ap1);
            XPoint2D p2 = translate2.getTranslated(ap2);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y2 = p2.getY() + dimDiamond1.getInY() + half;
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y1 + 12.0);
            double xx = Math.max(translate1.getDx(), translate2.getDx()) + ((XDimension2D)dimTotal).getWidth();
            snake.addPoint(xx, y1 + 12.0);
            snake.addPoint(xx, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1 + 12.0)).draw(new UEmpty(5.0, 12.0));
            ug = ug.apply(this.endInlinkColor.getColor()).apply(this.endInlinkColor.getColor().bg());
            ug.apply(new UTranslate(xx, (y1 + y2) / 2.0)).draw(Arrows.asToUp());
        }
    }

    class ConnectionBackBackward1
    extends AbstractConnection {
        private final Rainbow endInlinkColor;
        private final TextBlock back;

        public ConnectionBackBackward1(Rainbow endInlinkColor, TextBlock back) {
            super(FtileWhile.this.whileBlock, FtileWhile.this.backward);
            this.endInlinkColor = endInlinkColor;
            this.back = back;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(geo.getPointOut());
        }

        private double getBottom(StringBounder stringBounder) {
            FtileGeometry geo = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateForWhile(stringBounder).getDy() + geo.getHeight();
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dim = FtileWhile.this.backward.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateBackward(stringBounder).getTranslated(new XPoint2D(dim.getLeft(), dim.getOutY()));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.endInlinkColor, Arrows.asToUp()).withLabel(this.back, this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            double y1bis = Math.max(y1, this.getBottom(stringBounder)) + 12.0;
            snake.addPoint(x1, y1bis);
            snake.addPoint(x2, y1bis);
            snake.addPoint(x2, y2);
            ug.draw(snake);
            ug.apply(new UTranslate(x1, y1bis)).draw(new UEmpty(5.0, 12.0));
        }
    }

    class ConnectionBackBackward2
    extends AbstractConnection {
        private final Rainbow endInlinkColor;
        private final TextBlock back;

        public ConnectionBackBackward2(Rainbow endInlinkColor, TextBlock back) {
            super(FtileWhile.this.backward, FtileWhile.this.diamond1);
            this.endInlinkColor = endInlinkColor;
            this.back = back;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dim = FtileWhile.this.backward.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateBackward(stringBounder).getTranslated(new XPoint2D(dim.getLeft(), dim.getInY()));
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.endInlinkColor, Arrows.asToLeft()).withLabel(this.back, this.arrowHorizontalAlignment());
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y2 = p2.getY() + dimDiamond1.getInY() + half;
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection {
        private final Rainbow afterEndwhileColor;

        public ConnectionOut(Rainbow afterEndwhileColor) {
            super(FtileWhile.this.diamond1, null);
            this.afterEndwhileColor = afterEndwhileColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, 0.0));
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimTotal = FtileWhile.this.calculateDimension(stringBounder);
            return new XPoint2D(dimTotal.getLeft(), dimTotal.getHeight());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.afterEndwhileColor).withMerge(MergeStrategy.LIMITED).emphasizeDirection(Direction.DOWN);
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y1 = p1.getY() + dimDiamond1.getInY() + half;
            double x2 = p2.getX();
            double y2 = p2.getY();
            snake.addPoint(x1, y1);
            snake.addPoint(12.0, y1);
            snake.addPoint(12.0, y2);
            ug.draw(snake);
            Snake snake2 = Snake.create(FtileWhile.this.skinParam(), this.afterEndwhileColor);
            snake2.addPoint(12.0, y2);
            snake2.addPoint(x2, y2);
            ug.draw(snake2);
        }
    }

    class ConnectionOutSpecial
    extends AbstractConnection {
        private final Rainbow afterEndwhileColor;

        public ConnectionOutSpecial(Rainbow afterEndwhileColor) {
            super(FtileWhile.this.diamond1, FtileWhile.this.specialOut);
            this.afterEndwhileColor = afterEndwhileColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, 0.0));
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForSpecial(stringBounder).getTranslated(FtileWhile.this.specialOut.calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileWhile.this.skinParam(), this.afterEndwhileColor, Arrows.asToDown());
            FtileGeometry dimDiamond1 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            double y1 = p1.getY() + dimDiamond1.getInY() + half;
            double x2 = p2.getX();
            double y2 = p2.getY();
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }
}

