/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.AbstractParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ParallelBuilderMerge
extends AbstractParallelFtilesBuilder {
    public ParallelBuilderMerge(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> all) {
        super(skinParam, stringBounder, all);
    }

    @Override
    protected Ftile doStep1(Ftile inner) {
        Ftile result = inner;
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileBlackBlock black = new FtileBlackBlock(this.skinParam(), ((Ftile)this.list99.get(0)).getSwimlaneIn());
        double x = 0.0;
        for (Ftile tmp : this.list99) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            Style style = this.getStyleSignature().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            Rainbow def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            Rainbow rainbow = tmp.getInLinkRendering().getRainbow(def);
            conns.add(new ConnectionIn(black, tmp, x, rainbow));
            x += ((XDimension2D)dim).getWidth();
        }
        result = FtileUtils.addConnection(result, conns);
        black.setBlackBlockDimension(result.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        return new FtileAssemblySimple(black, result);
    }

    @Override
    protected Ftile doStep2(Ftile inner, Ftile result) {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam().getIHtmlColorSet());
        HColor backColor = style.value(PName.BackGroundColor).asColor(this.skinParam().getIHtmlColorSet());
        FtileDiamond out = new FtileDiamond(this.skinParam(), backColor, borderColor, this.swimlaneOutForStep2());
        result = new FtileAssemblySimple(result, out);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        UTranslate diamondTranslate = result.getTranslateFor(out, this.getStringBounder());
        double x = 0.0;
        for (Ftile tmp : this.list99) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            UTranslate translate0 = new UTranslate(x, 6.0);
            Rainbow def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            Rainbow rainbow = tmp.getOutLinkRendering().getRainbow(def);
            if (tmp.calculateDimension(this.getStringBounder()).hasPointOut()) {
                conns.add(new ConnectionHorizontalThenVertical(tmp, out, rainbow, translate0, diamondTranslate));
            }
            x += ((XDimension2D)dim).getWidth();
        }
        return FtileUtils.addConnection(result, conns);
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final Display label;

        public ConnectionIn(Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor) {
            super(ftile1, ftile2);
            this.label = ftile2.getInLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderMerge.this.getStringBounder());
            Snake snake = Snake.create(ParallelBuilderMerge.this.skinParam(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake = snake.withLabel(ParallelBuilderMerge.this.getTextBlock(this.label), this.arrowHorizontalAlignment());
            }
            snake.addPoint(geo.getLeft(), 0.0);
            snake.addPoint(geo.getLeft(), geo.getInY());
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderMerge.this.getStringBounder());
            XPoint2D p1 = new XPoint2D(geo.getLeft(), 0.0);
            XPoint2D p2 = new XPoint2D(geo.getLeft(), geo.getInY());
            Snake snake = Snake.create(ParallelBuilderMerge.this.skinParam(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake = snake.withLabel(ParallelBuilderMerge.this.getTextBlock(this.label), this.arrowHorizontalAlignment());
            }
            XPoint2D mp1a = translate1.getTranslated(p1);
            XPoint2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final UTranslate diamondTranslate;
        private final UTranslate translate0;

        public ConnectionHorizontalThenVertical(Ftile tile, Ftile diamond, Rainbow arrowColor, UTranslate translate0, UTranslate diamondTranslate) {
            super(tile, diamond);
            this.arrowColor = arrowColor;
            this.diamondTranslate = diamondTranslate;
            this.translate0 = translate0;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder, p1.getX());
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            UTranslate arrival = this.arrivalOnDiamond(stringBounder, p1.getX());
            UPolygon endDecoration = arrival.getDx() < 0.0 ? Arrows.asToRight() : (arrival.getDx() > 0.0 ? Arrows.asToLeft() : Arrows.asToDown());
            Snake snake = Snake.create(ParallelBuilderMerge.this.skinParam(), this.arrowColor, endDecoration);
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return this.translate0.getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private XPoint2D getP2(StringBounder stringBounder, double startX) {
            UTranslate arrival = this.arrivalOnDiamond(stringBounder, startX);
            return arrival.getTranslated(this.getDiamondOut(stringBounder));
        }

        public XPoint2D getDiamondOut(StringBounder stringBounder) {
            return this.diamondTranslate.getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointOut());
        }

        public UTranslate arrivalOnDiamond(StringBounder stringBounder, double startX) {
            XPoint2D result = this.getDiamondOut(stringBounder);
            FtileGeometry dim = this.getFtile2().calculateDimension(stringBounder);
            double a = result.getX() - ((XDimension2D)dim).getWidth() / 2.0;
            double b = result.getX() + ((XDimension2D)dim).getWidth() / 2.0;
            UTranslate arrival = startX < a ? new UTranslate(-((XDimension2D)dim).getWidth() / 2.0, -((XDimension2D)dim).getHeight() / 2.0) : (startX > b ? new UTranslate(((XDimension2D)dim).getWidth() / 2.0, -((XDimension2D)dim).getHeight() / 2.0) : new UTranslate(0.0, -((XDimension2D)dim).getHeight()));
            return arrival;
        }
    }
}

