/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class FtileBox2
extends AbstractFtile {
    private final ClockwiseTopRightBottomLeft padding;
    private final ClockwiseTopRightBottomLeft margin;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static FtileBox2 create(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Stereotype stereotype) {
        Style style = FtileBox2.getDefaultStyleDefinitionActivity().withTOBECHANGED(stereotype).getMergedStyle(skinParam.getCurrentStyleBuilder());
        Style styleArrow = FtileBox2.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new FtileBox2(skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    private FtileBox2(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        this.style = style = style.eventuallyOverride(specBack);
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet()));
        this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.padding = style.getPadding();
        this.margin = style.getMargin();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dimRaw = this.getDimRaw(ug.getStringBounder());
        double widthTotal = dimRaw.getWidth();
        double heightTotal = dimRaw.getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        FtileGeometry dimTotal = this.calculateDimension(ug.getStringBounder());
        ug.draw(new UEmpty(dimTotal));
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(HColors.none()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(HColors.none().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        ug = ug.apply(new UTranslate(this.margin.getLeft(), this.margin.getTop()));
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            XDimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(dimRaw.getWidth() - dimTb.getWidth() - this.padding.getRight(), this.padding.getBottom())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            XDimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((dimRaw.getWidth() - dimTb.getWidth()) / 2.0, this.padding.getBottom())));
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dimRaw = this.getDimRaw(stringBounder);
        return new FtileGeometry(dimRaw.getWidth() + this.margin.getLeft() + this.margin.getRight(), dimRaw.getHeight() + this.margin.getTop() + this.margin.getBottom(), this.margin.getLeft() + dimRaw.getWidth() / 2.0, this.margin.getTop(), this.margin.getTop() + dimRaw.getHeight());
    }

    private XDimension2D getDimRaw(StringBounder stringBounder) {
        XDimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = XDimension2D.delta(dimRaw, this.padding.getLeft() + this.padding.getRight() + this.boxStyle.getShield(), this.padding.getBottom() + this.padding.getTop());
        dimRaw = XDimension2D.atLeast(dimRaw, this.minimumWidth, 0.0);
        return dimRaw;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -FtileBox2.this.padding.getLeft();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBox2.this.calculateDimension(stringBounder);
            return ((XDimension2D)dim).getWidth() - FtileBox2.this.padding.getRight();
        }
    }
}

