/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileDiamondInside2
extends FtileDiamondWIP {
    public FtileDiamondInside2(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane) {
        this(label, skinParam, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondInside2 withNorth(TextBlock north) {
        return new FtileDiamondInside2(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, north, this.south, this.west, this.east);
    }

    public FtileDiamondInside2 withWest(TextBlock west) {
        return new FtileDiamondInside2(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, west, this.east);
    }

    public FtileDiamondInside2 withEast(TextBlock east) {
        return new FtileDiamondInside2(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.west, east);
    }

    public FtileDiamondInside2 withSouth(TextBlock south) {
        return new FtileDiamondInside2(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, south, this.west, this.east);
    }

    private FtileDiamondInside2(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock north, TextBlock south, TextBlock west, TextBlock east) {
        super(label, skinParam, backColor, borderColor, swimlane, north, south, east, west);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimLabel = this.label.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionAlone(stringBounder);
        ug = ug.apply(this.borderColor).apply(this.getThickness(this.getStyle())).apply(this.backColor.bg());
        ug.draw(Hexagon.asPolygon(this.shadowing, ((XDimension2D)dimTotal).getWidth(), ((XDimension2D)dimTotal).getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + ((XDimension2D)dimTotal).getWidth() / 2.0, ((XDimension2D)dimTotal).getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + ((XDimension2D)dimTotal).getWidth() / 2.0, ((XDimension2D)dimTotal).getHeight())));
        double lx = (((XDimension2D)dimTotal).getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (((XDimension2D)dimTotal).getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        XDimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + ((XDimension2D)dimTotal).getHeight() / 2.0)));
        XDimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(((XDimension2D)dimTotal).getWidth(), -dimEast.getHeight() + ((XDimension2D)dimTotal).getHeight() / 2.0)));
    }

    private FtileGeometry calculateDimensionAlone(StringBounder stringBounder) {
        XDimension2D dimLabel = this.label.calculateDimension(stringBounder);
        XDimension2D dim = dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0 ? new XDimension2D(24.0, 24.0) : XDimension2D.delta(XDimension2D.atLeast(dimLabel, 24.0, 24.0), 24.0, 0.0);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry diamond = this.calculateDimensionAlone(stringBounder);
        XDimension2D north = this.north.calculateDimension(stringBounder);
        double height = ((XDimension2D)diamond).getHeight() + north.getHeight();
        double left = ((XDimension2D)diamond).getWidth() / 2.0;
        double width = north.getWidth() > left ? left + north.getWidth() : ((XDimension2D)diamond).getWidth();
        return new FtileGeometry(width, height, left, 0.0, ((XDimension2D)diamond).getHeight());
    }
}

