/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.gtile.GAbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GConnectionVerticalDownThenHorizontal
extends GAbstractConnection {
    private final TextBlock textBlock;
    private final UTranslate pos1;
    private final UTranslate pos2;

    public GConnectionVerticalDownThenHorizontal(UTranslate pos1, GPoint gpoint1, UTranslate pos2, GPoint gpoint2, TextBlock textBlock) {
        super(gpoint1, gpoint2);
        this.textBlock = textBlock;
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        UPolygon arrow;
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        Direction originalDirection = Direction.leftOrRight(p1, p2);
        double x1 = p1.getX();
        double x2 = p2.getX();
        XPoint2D mp1a = translate1.getTranslated(p1);
        XPoint2D mp2b = translate2.getTranslated(p2);
        Direction newDirection = Direction.leftOrRight(mp1a, mp2b);
        UPolygon uPolygon = arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
        if (originalDirection == newDirection) {
            double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
            XPoint2D mp2bc = new XPoint2D(mp2b.getX() + delta, mp2b.getY());
            Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor()).withMerge(MergeStrategy.LIMITED);
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2bc.getX(), middle);
            snake.addPoint(mp2bc);
            ug.draw(snake);
            Snake small = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), arrow).withMerge(MergeStrategy.LIMITED);
            small.addPoint(mp2bc);
            small.addPoint(mp2bc.getX(), mp2b.getY());
            small.addPoint(mp2b);
            ug.draw(small);
        } else {
            double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
            XPoint2D mp2bb = new XPoint2D(mp2b.getX() + delta, mp2b.getY() - 18.0);
            Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor()).withMerge(MergeStrategy.LIMITED);
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), mp2bb.getY());
            snake.addPoint(mp2bb);
            ug.draw(snake);
            Snake small = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), arrow).withMerge(MergeStrategy.LIMITED);
            small.addPoint(mp2bb);
            small.addPoint(mp2bb.getX(), mp2b.getY());
            small.addPoint(mp2b);
            ug.draw(small);
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        UPolygon arrow = p1.getX() < p2.getX() ? Arrows.asToRight() : Arrows.asToLeft();
        Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), arrow).withLabel(this.textBlock, HorizontalAlignment.LEFT);
        snake.addPoint(p1);
        snake.addPoint(new XPoint2D(p1.getX(), p2.getY()));
        snake.addPoint(p2);
        ug.draw(snake);
    }
}

