/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileWithNoteOpale
extends AbstractGtile
implements Stencil,
Styleable {
    private final Gtile tile;
    private final Opale opale;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;
    private final UTranslate positionNote;
    private final UTranslate positionTile;
    private final XDimension2D dimNote;
    private final XDimension2D dimTile;

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.tile.getSwimlane(point);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    public GtileWithNoteOpale(Gtile tile, PositionedNote note, ISkinParam skinParam, boolean withLink) {
        super(tile.getStringBounder(), tile.skinParam());
        this.swimlaneNote = note.getSwimlaneNote();
        if (note.getColors() != null) {
            skinParam = note.getColors().mute(skinParam);
        }
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Style style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        UStroke stroke = style.getStroke();
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = Parser.build(fc, align, skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, withLink, stroke);
        this.dimNote = this.opale.calculateDimension(this.stringBounder);
        this.dimTile = tile.calculateDimension(this.stringBounder);
        XDimension2D dimTotal = this.calculateDimension(this.stringBounder);
        if (note.getNotePosition() == NotePosition.LEFT) {
            this.positionNote = new UTranslate(0.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(this.dimNote.getWidth() + 20.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        } else {
            this.positionNote = new UTranslate(this.dimTile.getWidth() + 20.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(0.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        }
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        return this.tile.getCoord(name).compose(this.positionTile);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double height = Math.max(this.dimNote.getHeight(), this.dimTile.getHeight());
        return new XDimension2D(this.dimTile.getWidth() + this.dimNote.getWidth() + 20.0, height);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        this.opale.drawU(ug.apply(this.positionNote));
        this.tile.drawU(ug.apply(this.positionTile));
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

