/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextArrow
extends AbstractComponentText
implements ArrowComponent {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;
    private final int maxAsciiMessageLength;

    public ComponentTextArrow(ComponentType type, ArrowConfiguration config, Display stringsToDisplay, FileFormat fileFormat, int maxAsciiMessageLength) {
        this.fileFormat = fileFormat;
        this.maxAsciiMessageLength = maxAsciiMessageLength;
        this.type = type;
        this.config = config;
        this.stringsToDisplay = ComponentTextArrow.cleanAndManageBoldNumber(stringsToDisplay, fileFormat);
    }

    public static Display cleanAndManageBoldNumber(Display orig, FileFormat fileFormat) {
        if (orig.size() == 0 || !(orig.get(0) instanceof MessageNumber)) {
            return orig;
        }
        Display result = Display.empty();
        for (int i = 0; i < orig.size(); ++i) {
            Object element = orig.get(i);
            if (i == 1) {
                element = ComponentTextArrow.removeTagAndManageBoldNumber(orig.get(0).toString(), fileFormat) + " " + (CharSequence)element;
            }
            if (i == 0) continue;
            result = result.add((CharSequence)element);
        }
        return result;
    }

    private static String removeTagAndManageBoldNumber(String s, FileFormat fileFormat) {
        if (fileFormat == FileFormat.UTXT) {
            Pattern pattern = Pattern.compile("\\<b\\>([0-9]+)\\</b\\>");
            Matcher matcher = pattern.matcher(s);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String num = matcher.group(1);
                String replace = StringUtils.toInternalBoldNumber(num);
                matcher.appendReplacement(result, Matcher.quoteReplacement(replace));
            }
            matcher.appendTail(result);
            s = result.toString();
        }
        return s.replaceAll("\\<[^<>]+\\>", "");
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        if (this.config.isHidden()) {
            return;
        }
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        int textWidth = StringUtils.getWcWidth(this.stringsToDisplay);
        int yarrow = height - 2;
        charArea.drawHLine(this.fileFormat == FileFormat.UTXT ? (char)'\u2500' : '-', yarrow, 1, width);
        if (this.config.isDotted()) {
            for (int i = 1; i < width; i += 2) {
                charArea.drawChar(' ', i, yarrow);
            }
        }
        if (this.config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            charArea.drawChar('>', width - 1, yarrow);
        } else if (this.config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
            charArea.drawChar('<', 1, yarrow);
        } else if (this.config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION) {
            charArea.drawChar('>', width - 1, yarrow);
            charArea.drawChar('<', 1, yarrow);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawStringsLRUnicode(this.stringsToDisplay.asList(), (width - textWidth) / 2, 0);
        } else {
            charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), (width - textWidth) / 2, 0);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        int width = StringUtils.getWcWidth(this.stringsToDisplay) + 2;
        if (this.maxAsciiMessageLength > 0) {
            return Math.min(this.maxAsciiMessageLength, width);
        }
        return width;
    }

    @Override
    public XPoint2D getStartPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        return new XPoint2D(0.0, 0.0);
    }

    @Override
    public XPoint2D getEndPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        return new XPoint2D(0.0, 0.0);
    }

    @Override
    public double getPaddingY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPosArrow(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

