/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.awt.geom;

import java.awt.Dimension;
import net.sourceforge.plantuml.utils.MathUtils;

public class XDimension2D {
    private final double width;
    private final double height;

    public XDimension2D() {
        this(0.0, 0.0);
    }

    public XDimension2D(double width, double height) {
        if (Double.isNaN(width) || Double.isNaN(height)) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "[" + this.width + "," + this.height + "]";
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public static XDimension2D delta(XDimension2D dim, double delta) {
        return XDimension2D.delta(dim, delta, delta);
    }

    public XDimension2D withWidth(double newWidth) {
        return new XDimension2D(newWidth, this.height);
    }

    public static XDimension2D delta(XDimension2D dim, double deltaWidth, double deltaHeight) {
        if (deltaHeight == 0.0 && deltaWidth == 0.0) {
            return dim;
        }
        return new XDimension2D(dim.getWidth() + deltaWidth, dim.getHeight() + deltaHeight);
    }

    public static XDimension2D mergeTB(XDimension2D top, XDimension2D bottom) {
        double width = Math.max(top.getWidth(), bottom.getWidth());
        double height = top.getHeight() + bottom.getHeight();
        return new XDimension2D(width, height);
    }

    public static XDimension2D mergeTB(XDimension2D a, XDimension2D b, XDimension2D c) {
        double width = MathUtils.max(a.getWidth(), b.getWidth(), c.getWidth());
        double height = a.getHeight() + b.getHeight() + c.getHeight();
        return new XDimension2D(width, height);
    }

    public static XDimension2D mergeLR(XDimension2D left, XDimension2D right) {
        double height = Math.max(left.getHeight(), right.getHeight());
        double width = left.getWidth() + right.getWidth();
        return new XDimension2D(width, height);
    }

    public static XDimension2D mergeLayoutT12B3(XDimension2D top1, XDimension2D top2, XDimension2D bottom) {
        double width = MathUtils.max(top1.getWidth(), top2.getWidth(), bottom.getWidth());
        double height = top1.getHeight() + top2.getHeight() + bottom.getHeight();
        return new XDimension2D(width, height);
    }

    public static XDimension2D max(XDimension2D dim1, XDimension2D dim2) {
        return XDimension2D.atLeast(dim1, dim2.getWidth(), dim2.getHeight());
    }

    public static XDimension2D atLeast(XDimension2D dim, double minWidth, double minHeight) {
        double h = dim.getHeight();
        double w = dim.getWidth();
        if (w > minWidth && h > minHeight) {
            return dim;
        }
        if (h < minHeight) {
            h = minHeight;
        }
        if (w < minWidth) {
            w = minWidth;
        }
        return new XDimension2D(w, h);
    }

    public static XDimension2D fromDimension(Dimension dimension) {
        return new XDimension2D(dimension.getWidth(), dimension.getHeight());
    }
}

