/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.awt.geom;

import net.sourceforge.plantuml.awt.XShape;
import net.sourceforge.plantuml.awt.geom.XPoint2D;

public class XLine2D
implements XShape {
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;

    public XLine2D() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public XLine2D(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public XPoint2D getMiddle() {
        double mx = (this.x1 + this.x2) / 2.0;
        double my = (this.y1 + this.y2) / 2.0;
        return new XPoint2D(mx, my);
    }

    public XLine2D(XPoint2D p1, XPoint2D p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public XPoint2D getP1() {
        return new XPoint2D(this.x1, this.y1);
    }

    public XPoint2D getP2() {
        return new XPoint2D(this.x2, this.y2);
    }

    public XLine2D withPoint1(XPoint2D other) {
        return new XLine2D(other.x, other.y, this.x2, this.y2);
    }

    public XLine2D withPoint2(XPoint2D other) {
        return new XLine2D(this.x1, this.y1, other.x, other.y);
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double projlenSq;
        double lenSq;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0.0 ? 0.0 : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }
}

