/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.awt.geom;

import net.sourceforge.plantuml.awt.XShape;
import net.sourceforge.plantuml.awt.geom.XPoint2D;

public class XRectangle2D
implements XShape {
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public XRectangle2D(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public double getMinX() {
        return this.x;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public boolean intersects(XRectangle2D other) {
        return this.intersects(other.getX(), other.getY(), other.getWidth(), other.getHeight());
    }

    private boolean intersects(double x, double y, double w, double h) {
        return w > 0.0 && h > 0.0 && this.getWidth() > 0.0 && this.getHeight() > 0.0 && x < this.getX() + this.getWidth() && x + w > this.getX() && y < this.getY() + this.getHeight() && y + h > this.getY();
    }

    public boolean contains(XPoint2D point) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(double xp, double yp) {
        if (this.width <= 0.0 || this.height <= 0.0) {
            throw new IllegalStateException();
        }
        return xp >= this.getMinX() && xp < this.getMaxX() && yp >= this.getMinY() && yp < this.getMaxY();
    }
}

