/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.SheetBuilder;
import net.sourceforge.plantuml.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class Parser {
    public static final String MONOSPACED = "monospaced";

    public static SheetBuilder build(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode) {
        FontConfiguration stereotype = fontConfiguration.forceFont(null, null);
        return new CreoleParser(fontConfiguration, horizontalAlignment, skinParam, creoleMode, stereotype);
    }

    public static SheetBuilder build(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode, FontConfiguration stereotype) {
        return new CreoleParser(fontConfiguration, horizontalAlignment, skinParam, creoleMode, stereotype);
    }

    public static boolean isLatexStart(String line) {
        return line.equals("<latex>");
    }

    public static boolean isLatexEnd(String line) {
        return line.equals("</latex>");
    }

    public static boolean isCodeStart(String line) {
        return line.equals("<code>");
    }

    public static boolean isCodeEnd(String line) {
        return line.equals("</code>");
    }

    public static boolean isTreeStart(String line) {
        return line.startsWith("|_");
    }

    public static double getScale(String s, double def) {
        if (s == null) {
            return def;
        }
        Pattern p = Pattern.compile("(?:scale=|\\*)([0-9.]+)");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return Double.parseDouble(m.group(1));
        }
        return def;
    }

    public static String getColor(String s) {
        if (s == null) {
            return null;
        }
        Pattern p = Pattern.compile("color[= :](#[0-9a-fA-F]{6}|\\w+)");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

