/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Objects;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Removeable;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.CucaNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkConstraint;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.WithLinkType;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Link
extends WithLinkType
implements Hideable,
Removeable {
    private final IEntity cl1;
    private final IEntity cl2;
    private String port1;
    private String port2;
    private final LinkArg linkArg;
    private final String uid;
    private CucaNote note;
    private boolean invis = false;
    private double weight = 1.0;
    private boolean constraint = true;
    private boolean inverted = false;
    private LinkArrow linkArrow = LinkArrow.NONE_OR_SEVERAL;
    private boolean opale;
    private boolean horizontalSolitary;
    private String sametail;
    private final StyleBuilder styleBuilder;
    private Stereotype stereotype;
    private Url url;
    private UmlDiagramType umlType;
    private LinkConstraint linkConstraint;
    private LineLocation codeLine;

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public String idCommentForSvg() {
        if (this.type.looksLikeRevertedForSvg()) {
            return this.getEntity1().getCodeGetName() + "-backto-" + this.getEntity2().getCodeGetName();
        }
        if (this.type.looksLikeNoDecorAtAllSvg()) {
            return this.getEntity1().getCodeGetName() + "-" + this.getEntity2().getCodeGetName();
        }
        return this.getEntity1().getCodeGetName() + "-to-" + this.getEntity2().getCodeGetName();
    }

    public UComment commentForSvg() {
        if (this.type.looksLikeRevertedForSvg()) {
            return new UComment("reverse link " + this.getEntity1().getCodeGetName() + " to " + this.getEntity2().getCodeGetName());
        }
        return new UComment("link " + this.getEntity1().getCodeGetName() + " to " + this.getEntity2().getCodeGetName());
    }

    public Link(StyleBuilder styleBuilder, IEntity cl1, IEntity cl2, LinkType type, LinkArg linkArg) {
        if (linkArg.getLength() < 1) {
            throw new IllegalArgumentException();
        }
        this.styleBuilder = styleBuilder;
        this.cl1 = Objects.requireNonNull(cl1);
        this.cl2 = Objects.requireNonNull(cl2);
        this.type = type;
        CucaDiagram diagram = ((EntityImpl)cl1).getDiagram();
        this.uid = "LNK" + diagram.getUniqueSequence();
        this.linkArg = linkArg;
        if (diagram.getPragma().useKermor() && !cl1.getEntityPosition().isNormal() ^ !cl2.getEntityPosition().isNormal()) {
            this.setConstraint(false);
        }
    }

    public Link getInv() {
        Link result = new Link(this.styleBuilder, this.cl2, this.cl1, this.getType().getInversed(), this.linkArg.getInv());
        result.inverted = !this.inverted;
        result.port1 = this.port2;
        result.port2 = this.port1;
        result.url = this.url;
        result.linkConstraint = this.linkConstraint;
        result.stereotype = this.stereotype;
        result.linkArg.setVisibilityModifier(this.linkArg.getVisibilityModifier());
        return result;
    }

    @Override
    public void goNorank() {
        this.setConstraint(false);
    }

    public String getLabeldistance() {
        return this.getLinkArg().getLabeldistance();
    }

    public String getLabelangle() {
        return this.getLinkArg().getLabelangle();
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        if (this.type.isInvisible()) {
            return true;
        }
        return this.invis;
    }

    public final void setInvis(boolean invis) {
        this.invis = invis;
    }

    public boolean isBetween(IEntity cl1, IEntity cl2) {
        if (cl1.equals(this.cl1) && cl2.equals(this.cl2)) {
            return true;
        }
        return cl1.equals(this.cl2) && cl2.equals(this.cl1);
    }

    public String toString() {
        return super.toString() + " {" + this.linkArg.getLength() + "} " + this.cl1 + "-->" + this.cl2;
    }

    public IEntity getEntity1() {
        return this.cl1;
    }

    public IEntity getEntity2() {
        return this.cl2;
    }

    public EntityPort getEntityPort1(Bibliotekon bibliotekon) {
        return this.getEntityPort((ILeaf)this.cl1, this.port1, bibliotekon);
    }

    public EntityPort getEntityPort2(Bibliotekon bibliotekon) {
        return this.getEntityPort((ILeaf)this.cl2, this.port2, bibliotekon);
    }

    private EntityPort getEntityPort(ILeaf leaf, String port, Bibliotekon bibliotekon) {
        if (leaf.getEntityPosition().usePortP()) {
            return EntityPort.forPort(bibliotekon.getNodeUid(leaf));
        }
        return EntityPort.create(bibliotekon.getNodeUid(leaf), port);
    }

    @Override
    public LinkType getType() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (this.getSametail() != null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private boolean isReallyGroup(IEntity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        IGroup group = (IGroup)ent;
        return group.getChildren().size() + group.getLeafsDirect().size() > 0;
    }

    public LinkType getTypePatchCluster() {
        LinkType result = this.getType();
        if (this.isReallyGroup(this.getEntity1())) {
            result = result.withoutDecors2();
        }
        if (this.isReallyGroup(this.getEntity2())) {
            result = result.withoutDecors1();
        }
        return result;
    }

    private LinkType getTypeSpecialForPrinting() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private boolean isLollipopInterfaceEye(IEntity ent) {
        return ent.getUSymbol() instanceof USymbolInterface;
    }

    public Display getLabel() {
        return this.getLinkArg().getLabel();
    }

    public int getLength() {
        return this.getLinkArg().getLength();
    }

    public final void setLength(int length) {
        this.getLinkArg().setLength(length);
    }

    public String getQuantifier1() {
        return this.getLinkArg().getQuantifier1();
    }

    public String getQuantifier2() {
        return this.getLinkArg().getQuantifier2();
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double weight) {
        this.weight = weight;
    }

    public final CucaNote getNote() {
        return this.note;
    }

    public final void addNote(CucaNote note) {
        this.note = note;
    }

    public final void addNoteFrom(Link other, NoteLinkStrategy strategy) {
        if (other.note != null) {
            this.note = other.note.withStrategy(strategy);
        }
    }

    public boolean isAutoLinkOfAGroup() {
        if (!this.getEntity1().isGroup()) {
            return false;
        }
        if (!this.getEntity2().isGroup()) {
            return false;
        }
        return this.getEntity1() == this.getEntity2();
    }

    public boolean containsType(LeafType type) {
        return this.getEntity1().getLeafType() == type || this.getEntity2().getLeafType() == type;
    }

    public boolean contains(IEntity entity) {
        if (Link.isSame(this.getEntity1(), entity)) {
            return true;
        }
        return Link.isSame(this.getEntity2(), entity);
    }

    private static boolean isSame(IEntity a, IEntity b) {
        if (a == b) {
            return true;
        }
        if (((EntityImpl)a).getOriginalGroup() == b) {
            return true;
        }
        return ((EntityImpl)b).getOriginalGroup() == a;
    }

    public IEntity getOther(IEntity entity) {
        if (Link.isSame(this.getEntity1(), entity)) {
            return this.getEntity2();
        }
        if (Link.isSame(this.getEntity2(), entity)) {
            return this.getEntity1();
        }
        throw new IllegalArgumentException();
    }

    private double getQuantifierMargin(StringBounder stringBounder, UFont fontQualif, String qualif, ISkinSimple spriteContainer) {
        if (qualif != null) {
            TextBlock b = Display.create(qualif).create(FontConfiguration.blackBlueTrue(fontQualif), HorizontalAlignment.LEFT, spriteContainer);
            XDimension2D dim = b.calculateDimension(stringBounder);
            return Math.max(dim.getWidth(), dim.getHeight());
        }
        return 0.0;
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    public void setOpale(boolean opale) {
        this.opale = opale;
    }

    public final void setHorizontalSolitary(boolean horizontalSolitary) {
        this.horizontalSolitary = horizontalSolitary;
    }

    public final boolean isHorizontalSolitary() {
        return this.horizontalSolitary;
    }

    public final LinkArrow getLinkArrow() {
        if (this.inverted) {
            return this.linkArrow.reverse();
        }
        return this.linkArrow;
    }

    public final void setLinkArrow(LinkArrow linkArrow) {
        this.linkArrow = linkArrow;
    }

    public final boolean isInverted() {
        return this.inverted;
    }

    public boolean hasEntryPoint() {
        return !this.getEntity1().isGroup() && this.getEntity1().getEntityPosition() != EntityPosition.NORMAL || !this.getEntity2().isGroup() && this.getEntity2().getEntityPosition() != EntityPosition.NORMAL;
    }

    public boolean hasTwoEntryPointsSameContainer() {
        return !this.getEntity1().isGroup() && !this.getEntity2().isGroup() && this.getEntity1().getEntityPosition() != EntityPosition.NORMAL && this.getEntity2().getEntityPosition() != EntityPosition.NORMAL && this.getEntity1().getParentContainer() == this.getEntity2().getParentContainer();
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    @Override
    public boolean isHidden() {
        return this.hidden || this.cl1.isHidden() || this.cl2.isHidden();
    }

    public boolean sameConnections(Link other) {
        if (this.cl1 == other.cl1 && this.cl2 == other.cl2) {
            return true;
        }
        return this.cl1 == other.cl2 && this.cl2 == other.cl1;
    }

    public boolean doesTouch(Link other) {
        if (this.cl1 == other.cl1) {
            return true;
        }
        if (this.cl1 == other.cl2) {
            return true;
        }
        if (this.cl2 == other.cl1) {
            return true;
        }
        return this.cl2 == other.cl2;
    }

    public boolean isAutolink() {
        return this.cl1 == this.cl2;
    }

    @Override
    public boolean isRemoved() {
        return this.cl1.isRemoved() || this.cl2.isRemoved();
    }

    public boolean hasUrl() {
        if (!Display.isNull(this.linkArg.getLabel()) && this.linkArg.getLabel().hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    public String getSametail() {
        return this.sametail;
    }

    public void setSametail(String sametail) {
        this.sametail = sametail;
    }

    public void setPortMembers(String port1, String port2) {
        this.port1 = port1;
        this.port2 = port2;
        if (port1 != null) {
            ((ILeaf)this.cl1).addPortShortName(port1);
        }
        if (port2 != null) {
            ((ILeaf)this.cl2).addPortShortName(port2);
        }
    }

    public void setUmlDiagramType(UmlDiagramType type) {
        this.umlType = type;
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlType;
    }

    public void setLinkConstraint(LinkConstraint linkConstraint) {
        this.linkConstraint = linkConstraint;
    }

    public final LinkConstraint getLinkConstraint() {
        return this.linkConstraint;
    }

    public String getCodeLine() {
        if (this.codeLine == null) {
            return null;
        }
        return "" + this.codeLine.getPosition();
    }

    public void setCodeLine(LineLocation location) {
        this.codeLine = location;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public final LinkArg getLinkArg() {
        return this.linkArg;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.getLinkArg().getVisibilityModifier();
    }
}

