/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public final class CucaDiagramTxtMaker {
    private final FileFormat fileFormat;
    private final UGraphicTxt globalUg = new UGraphicTxt();
    private final PortionShower portionShower;

    private static double getXPixelPerChar() {
        return 5.0;
    }

    private static double getYPixelPerChar() {
        return 10.0;
    }

    private boolean showMember(IEntity entity) {
        boolean showMethods = this.portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = this.portionShower.showPortion(EntityPortion.FIELD, entity);
        return showMethods || showFields;
    }

    public CucaDiagramTxtMaker(CucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.fileFormat = fileFormat;
        this.portionShower = diagram;
        Cluster root = new Cluster(null, 0.0, 0.0);
        int uid = 0;
        HashMap<IEntity, Block> blocks = new HashMap<IEntity, Block>();
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            double width = (double)this.getWidth(iEntity) * CucaDiagramTxtMaker.getXPixelPerChar();
            double height = (double)this.getHeight(iEntity) * CucaDiagramTxtMaker.getYPixelPerChar();
            Block b = new Block(uid++, width, height, null);
            root.addBloc(b);
            blocks.put(iEntity, b);
        }
        GraphvizSolverB solver = new GraphvizSolverB();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Link link : diagram.getLinks()) {
            Block b1 = (Block)blocks.get(link.getEntity1());
            Block b2 = (Block)blocks.get(link.getEntity2());
            arrayList.add(new Path(b1, b2, null, link.getLength(), link.isInvis()));
        }
        solver.solve(root, arrayList);
        for (Path path : arrayList) {
            if (path.isInvis()) continue;
            path.getDotPath().draw(this.globalUg.getCharArea(), CucaDiagramTxtMaker.getXPixelPerChar(), CucaDiagramTxtMaker.getYPixelPerChar());
        }
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            Block b = (Block)blocks.get(iEntity);
            XPoint2D p = b.getPosition();
            this.printClass(iEntity, (UGraphicTxt)this.globalUg.apply(new UTranslate(p.getX() / CucaDiagramTxtMaker.getXPixelPerChar(), p.getY() / CucaDiagramTxtMaker.getYPixelPerChar())));
        }
    }

    private void printClass(IEntity ent, UGraphicTxt ug) {
        int w = this.getWidth(ent);
        int h = this.getHeight(ent);
        ug.getCharArea().drawBoxSimple(0, 0, w, h);
        ug.getCharArea().drawStringsLRSimple(ent.getDisplay().asList(), 1, 1);
        if (this.showMember(ent)) {
            int y = 2;
            ug.getCharArea().drawHLine('-', y, 1, w - 1);
            ++y;
            for (CharSequence att : ent.getBodier().getRawBody()) {
                List<String> disp = BackSlash.getWithNewlines(att.toString());
                ug.getCharArea().drawStringsLRSimple(disp, 1, y);
                y += StringUtils.getHeight(disp);
            }
        }
    }

    public List<SFile> createFiles(SFile suggestedFile) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            this.globalUg.getCharArea().print(suggestedFile.createPrintStream(StandardCharsets.UTF_8));
        } else {
            this.globalUg.getCharArea().print(suggestedFile.createPrintStream());
        }
        return Collections.singletonList(suggestedFile);
    }

    private int getHeight(IEntity entity) {
        int result = StringUtils.getHeight(entity.getDisplay());
        if (this.showMember(entity)) {
            for (CharSequence att : entity.getBodier().getRawBody()) {
                result += StringUtils.getHeight(Display.getWithNewlines(att.toString()));
            }
        }
        return result + 3;
    }

    private int getWidth(IEntity entity) {
        int result = StringUtils.getWcWidth(entity.getDisplay());
        if (this.showMember(entity)) {
            for (CharSequence att : entity.getBodier().getRawBody()) {
                int w = StringUtils.getWcWidth(Display.getWithNewlines(att.toString()));
                if (w <= result) continue;
                result = w;
            }
        }
        return result + 2;
    }

    public void createFiles(OutputStream os, int index) {
        this.globalUg.getCharArea().print(SecurityUtils.createPrintStream(os));
    }
}

