/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.ebnf.CharIterator;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.ETileEmpty;
import net.sourceforge.plantuml.ebnf.ETileWithCircles;
import net.sourceforge.plantuml.ebnf.EbnfEngine;
import net.sourceforge.plantuml.ebnf.ShuntingYard;
import net.sourceforge.plantuml.ebnf.Symbol;
import net.sourceforge.plantuml.ebnf.TextBlockable;
import net.sourceforge.plantuml.ebnf.TitleBox;
import net.sourceforge.plantuml.ebnf.Token;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EbnfExpression
implements TextBlockable {
    private final List<Token> tokens = new ArrayList<Token>();
    private final boolean isCompact;
    private final String commentAbove;
    private final String commentBelow;

    public static EbnfExpression create(CharIterator it, boolean isCompact, String commentAbove, String commentBelow) {
        return new EbnfExpression(it, isCompact, commentAbove, commentBelow);
    }

    private EbnfExpression(CharIterator it, boolean isCompact, String commentAbove, String commentBelow) {
        this.isCompact = isCompact;
        this.commentAbove = commentAbove;
        this.commentBelow = commentBelow;
        while (true) {
            char ch;
            if (!Character.isWhitespace(ch = it.peek(0))) {
                String litteral;
                if (this.isLetterOrDigit(ch)) {
                    litteral = this.readLitteral(it);
                    this.tokens.add(new Token(Symbol.LITTERAL, litteral));
                    continue;
                }
                if (ch == '*') {
                    this.tokens.add(new Token(Symbol.REPETITION_SYMBOL, null));
                } else {
                    if (ch == '(' && it.peek(1) == '*') {
                        String comment = this.readComment(it);
                        if (comment.trim().length() <= 0) continue;
                        this.tokens.add(new Token(Symbol.COMMENT_TOKEN, comment));
                        continue;
                    }
                    if (ch == ',') {
                        this.tokens.add(new Token(Symbol.CONCATENATION, null));
                    } else if (ch == '|') {
                        this.tokens.add(new Token(Symbol.ALTERNATION, null));
                    } else if (ch == '=') {
                        this.tokens.add(new Token(Symbol.DEFINITION, null));
                    } else if (ch == '(') {
                        this.tokens.add(new Token(Symbol.GROUPING_OPEN, null));
                    } else if (ch == ')') {
                        this.tokens.add(new Token(Symbol.GROUPING_CLOSE, null));
                    } else if (ch == '[') {
                        this.tokens.add(new Token(Symbol.OPTIONAL_OPEN, null));
                    } else if (ch == ']') {
                        this.tokens.add(new Token(Symbol.OPTIONAL_CLOSE, null));
                    } else if (ch == '{') {
                        this.tokens.add(new Token(Symbol.REPETITION_OPEN, null));
                    } else if (ch == '}' && it.peek(1) == '-') {
                        this.tokens.add(new Token(Symbol.REPETITION_MINUS_CLOSE, null));
                        it.next();
                    } else if (ch == '}') {
                        this.tokens.add(new Token(Symbol.REPETITION_CLOSE, null));
                    } else {
                        if (ch == ';' || ch == '\u0000') break;
                        if (ch == '\"') {
                            litteral = this.readString(it);
                            this.tokens.add(new Token(Symbol.TERMINAL_STRING1, litteral));
                        } else if (ch == '\'') {
                            litteral = this.readString(it);
                            this.tokens.add(new Token(Symbol.TERMINAL_STRING2, litteral));
                        } else {
                            this.tokens.clear();
                            return;
                        }
                    }
                }
            }
            it.next();
        }
    }

    @Override
    public TextBlock getUDrawable(ISkinParam skinParam) {
        Style style = ETile.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        if (this.tokens.size() == 0) {
            return EbnfEngine.syntaxError(fc, skinParam);
        }
        try {
            TextBlock main;
            Iterator<Token> iterator = this.tokens.iterator();
            Token name = iterator.next();
            Token definition = iterator.next();
            if (definition.getSymbol() != Symbol.DEFINITION) {
                return EbnfEngine.syntaxError(fc, skinParam);
            }
            if (iterator.hasNext()) {
                List<Token> full = new ShuntingYard(iterator).getOuputQueue();
                if (full.size() == 0) {
                    return EbnfEngine.syntaxError(fc, skinParam);
                }
                main = this.getMainDrawing(skinParam, full.iterator());
            } else {
                HColor lineColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
                main = new ETileWithCircles(new ETileEmpty(), lineColor);
            }
            TextBlock titleBox = new TitleBox(name.getData(), fc);
            if (this.commentAbove != null) {
                titleBox = TextBlockUtils.mergeTB(this.getNoteAbove(skinParam), titleBox, HorizontalAlignment.CENTER);
            }
            if (this.commentBelow != null) {
                titleBox = TextBlockUtils.mergeTB(titleBox, this.getNoteBelow(skinParam), HorizontalAlignment.CENTER);
            }
            return TextBlockUtils.mergeTB(titleBox, TextBlockUtils.withMargin(main, 0.0, 0.0, 10.0, 15.0), HorizontalAlignment.LEFT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return EbnfEngine.syntaxError(fc, skinParam);
        }
    }

    private TextBlock getNoteAbove(ISkinParam skinParam) {
        if (this.commentAbove == null) {
            return null;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentAbove), skinParam, SName.ebnf);
        return note;
    }

    private TextBlock getNoteBelow(ISkinParam skinParam) {
        if (this.commentBelow == null) {
            return null;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentBelow), skinParam, SName.ebnf);
        return note;
    }

    private TextBlock getMainDrawing(ISkinParam skinParam, Iterator<Token> it) {
        EbnfEngine engine = new EbnfEngine(skinParam);
        while (it.hasNext()) {
            Token element = it.next();
            if (element.getSymbol() == Symbol.TERMINAL_STRING1 || element.getSymbol() == Symbol.TERMINAL_STRING2 || element.getSymbol() == Symbol.LITTERAL) {
                engine.push(element);
                continue;
            }
            if (element.getSymbol() == Symbol.COMMENT_ABOVE) {
                engine.commentAbove(element.getData());
                continue;
            }
            if (element.getSymbol() == Symbol.COMMENT_BELOW) {
                engine.commentBelow(element.getData());
                continue;
            }
            if (element.getSymbol() == Symbol.ALTERNATION) {
                engine.alternation();
                continue;
            }
            if (element.getSymbol() == Symbol.CONCATENATION) {
                engine.concatenation();
                continue;
            }
            if (element.getSymbol() == Symbol.OPTIONAL) {
                engine.optional();
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_ZERO_OR_MORE) {
                engine.repetitionZeroOrMore(this.isCompact);
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_ONE_OR_MORE) {
                engine.repetitionOneOrMore();
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_SYMBOL) {
                engine.repetitionSymbol();
                continue;
            }
            throw new UnsupportedOperationException(element.toString());
        }
        return engine.getTextBlock();
    }

    private String readString(CharIterator it) {
        char separator = it.peek(0);
        it.next();
        StringBuilder sb = new StringBuilder();
        char ch;
        while ((ch = it.peek(0)) != separator) {
            sb.append(ch);
            it.next();
        }
        return sb.toString();
    }

    private String readLitteral(CharIterator it) {
        StringBuilder sb = new StringBuilder();
        char ch;
        while (this.isLetterOrDigit(ch = it.peek(0))) {
            sb.append(ch);
            it.next();
        }
        return sb.toString();
    }

    private String readComment(CharIterator it) {
        StringBuilder sb = new StringBuilder();
        it.next();
        it.next();
        char ch;
        while ((ch = it.peek(0)) != '\u0000') {
            if (ch == '*' && it.peek(1) == ')') {
                it.next();
                it.next();
                return sb.toString();
            }
            sb.append(ch);
            it.next();
        }
        return sb.toString();
    }

    private boolean isLetterOrDigit(char ch) {
        return ch == '-' || ch == '_' || Character.isLetterOrDigit(ch);
    }

    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }
}

