/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockRaw;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final double margin = 5.0;
    private final HColor background;
    private static final HColor hyperlinkColor = HColors.BLUE;
    private static final UStroke useUnderlineForHyperlink = new UStroke();
    private final List<String> strings;
    private final BufferedImage image;
    private final double imagePadding = 30.0;
    private final GraphicPosition position;
    private final FontConfiguration fontConfiguration;
    private final CreoleMode mode;

    public static IEntityImage createForError(List<String> strings, boolean useRed) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif14(GraphicStrings.getForeColor(useRed)).bold(), GraphicStrings.getBackColor(useRed), null, null, CreoleMode.NO_CREOLE);
    }

    private static HColor getForeColor(boolean useRed) {
        if (useRed) {
            return HColors.BLACK;
        }
        return HColors.MY_GREEN;
    }

    private static HColor getBackColor(boolean useRed) {
        if (useRed) {
            return HColors.RED_LIGHT;
        }
        return HColors.BLACK;
    }

    public static TextBlockBackcolored createGreenOnBlackMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(HColors.GREEN), HColors.BLACK, null, null, CreoleMode.SIMPLE_LINE);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(HColors.BLACK), HColors.WHITE, null, null, CreoleMode.FULL);
    }

    public static TextBlockBackcolored createBlackOnWhiteMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(HColors.BLACK), HColors.WHITE, null, null, CreoleMode.FULL);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings, BufferedImage image, GraphicPosition position) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(HColors.BLACK), HColors.WHITE, image, position, CreoleMode.FULL_BUT_UNDERSCORE);
    }

    public static FontConfiguration sansSerif12(HColor color) {
        return FontConfiguration.create(UFont.sansSerif(12), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    public static FontConfiguration sansSerif14(HColor color) {
        return FontConfiguration.create(UFont.sansSerif(14), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    private static FontConfiguration monospaced14(HColor color) {
        return FontConfiguration.create(UFont.monospaced(14), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    private GraphicStrings(List<String> strings, FontConfiguration fontConfiguration, HColor background, BufferedImage image, GraphicPosition position, CreoleMode mode) {
        this.strings = strings;
        this.background = background;
        this.image = image;
        this.position = position;
        this.mode = mode;
        this.fontConfiguration = fontConfiguration;
    }

    private TextBlock getTextBlock() {
        Display display = Display.create(this.strings);
        if (this.mode == CreoleMode.NO_CREOLE) {
            return new TextBlockRaw(this.strings, this.fontConfiguration);
        }
        return display.create7(this.fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty(), this.mode);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        XDimension2D size = this.calculateDimensionInternal(ug.getStringBounder());
        this.getTextBlock().drawU(ug.apply(this.fontConfiguration.getColor()));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                ug.apply(new UTranslate((size.getWidth() - (double)this.image.getWidth()) / 2.0, size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth(), size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            }
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return XDimension2D.delta(this.calculateDimensionInternal(stringBounder), 10.0);
    }

    private XDimension2D calculateDimensionInternal(StringBounder stringBounder) {
        XDimension2D dim = this.getTextBlock().calculateDimension(stringBounder);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dim = new XDimension2D(dim.getWidth(), dim.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dim = new XDimension2D(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dim = new XDimension2D(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            }
        }
        return dim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HColor getBackcolor() {
        return this.background;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

