/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMinWidth
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final double minWidth;
    private final HorizontalAlignment horizontalAlignment;

    TextBlockMinWidth(TextBlock textBlock, double minWidth, HorizontalAlignment horizontalAlignment) {
        this.textBlock = textBlock;
        this.minWidth = minWidth;
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return XDimension2D.atLeast(dim, this.minWidth, 0.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.textBlock.drawU(ug);
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            XDimension2D dimText = this.textBlock.calculateDimension(ug.getStringBounder());
            XDimension2D dimFull = this.calculateDimension(ug.getStringBounder());
            double diffx = dimFull.getWidth() - dimText.getWidth();
            this.textBlock.drawU(ug.apply(UTranslate.dx(diffx / 2.0)));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            XDimension2D dimText = this.textBlock.calculateDimension(ug.getStringBounder());
            XDimension2D dimFull = this.calculateDimension(ug.getStringBounder());
            double diffx = dimFull.getWidth() - dimText.getWidth();
            this.textBlock.drawU(ug.apply(UTranslate.dx(diffx)));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

