/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.SingleLine;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class TextBlockSimple
extends AbstractTextBlock
implements TextBlock {
    private List<Line> lines;
    private final Display texts;
    private final FontConfiguration fontConfiguration;
    private final HorizontalAlignment horizontalAlignment;
    private final SpriteContainer spriteContainer;
    private final double maxMessageSize;

    public TextBlockSimple(Display texts, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, double maxMessageSize) {
        this.texts = texts;
        this.fontConfiguration = fontConfiguration;
        this.horizontalAlignment = horizontalAlignment;
        this.spriteContainer = spriteContainer;
        this.maxMessageSize = maxMessageSize;
    }

    private List<Line> getLines(StringBounder stringBounder) {
        if (this.lines == null) {
            if (stringBounder == null) {
                throw new IllegalStateException();
            }
            this.lines = new ArrayList<Line>();
            for (CharSequence s : this.texts) {
                if (s instanceof EmbeddedDiagram) {
                    this.lines.add(((EmbeddedDiagram)s).asDraw(null));
                    continue;
                }
                this.addInLines(stringBounder, s.toString());
            }
        }
        return this.lines;
    }

    private void addInLines(StringBounder stringBounder, String s) {
        if (this.maxMessageSize == 0.0) {
            this.addSingleLine(s);
        } else if (this.maxMessageSize > 0.0) {
            StringTokenizer st = new StringTokenizer(s, " ", true);
            StringBuilder currentLine = new StringBuilder();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                double w = this.getTextWidth(stringBounder, currentLine + token);
                if (w > this.maxMessageSize) {
                    this.addSingleLineNoSpace(currentLine.toString());
                    currentLine.setLength(0);
                    if (token.startsWith(" ")) continue;
                    currentLine.append(token);
                    continue;
                }
                currentLine.append(token);
            }
            this.addSingleLineNoSpace(currentLine.toString());
        } else if (this.maxMessageSize < 0.0) {
            StringBuilder currentLine = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                double w = this.getTextWidth(stringBounder, currentLine.toString() + c);
                if (w > -this.maxMessageSize) {
                    this.addSingleLineNoSpace(currentLine.toString());
                    currentLine.setLength(0);
                    if (c == ' ') continue;
                    currentLine.append(c);
                    continue;
                }
                currentLine.append(c);
            }
            this.addSingleLineNoSpace(currentLine.toString());
        }
    }

    private void addSingleLineNoSpace(String s) {
        if (s.length() == 0 || MyPattern.mtches(s, "^[%s]*$ ")) {
            return;
        }
        this.lines.add(SingleLine.withSomeHtmlTag(s, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer));
    }

    private void addSingleLine(String s) {
        this.lines.add(SingleLine.withSomeHtmlTag(s, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer));
    }

    private double getTextWidth(StringBounder stringBounder, String s) {
        SingleLine line = SingleLine.withSomeHtmlTag(s, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer);
        return line.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final XDimension2D getTextDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Line line : this.getLines(stringBounder)) {
            XDimension2D size2D = line.calculateDimension(stringBounder);
            height += size2D.getHeight();
            width = Math.max(width, size2D.getWidth());
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        XDimension2D dimText = this.getTextDimension(ug.getStringBounder());
        for (Line line : this.getLines(ug.getStringBounder())) {
            double diff;
            HorizontalAlignment lineHorizontalAlignment = line.getHorizontalAlignment();
            double deltaX = 0.0;
            if (lineHorizontalAlignment == HorizontalAlignment.CENTER) {
                diff = dimText.getWidth() - line.calculateDimension(ug.getStringBounder()).getWidth();
                deltaX = diff / 2.0;
            } else if (lineHorizontalAlignment == HorizontalAlignment.RIGHT) {
                deltaX = diff = dimText.getWidth() - line.calculateDimension(ug.getStringBounder()).getWidth();
            }
            line.drawU(ug.apply(new UTranslate(deltaX, y)));
            y += line.calculateDimension(ug.getStringBounder()).getHeight();
        }
    }
}

