/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockVertical2
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    TextBlockVertical2(TextBlock b1, TextBlock b2, HorizontalAlignment horizontalAlignment) {
        this.blocks.add(b1);
        this.blocks.add(b2);
        this.horizontalAlignment = horizontalAlignment;
    }

    TextBlockVertical2(TextBlock b1, UImage image, HorizontalAlignment horizontalAlignment) {
        this(b1, TextBlockVertical2.convertImage(image), horizontalAlignment);
    }

    private static AbstractTextBlock convertImage(final UImage image) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(image);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(image.getWidth(), image.getHeight());
            }
        };
    }

    public TextBlockVertical2(List<TextBlock> all, HorizontalAlignment horizontalAlignment) {
        if (all.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(all);
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dim = XDimension2D.mergeTB(dim, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        XDimension2D dimtotal = this.calculateDimension(ug.getStringBounder());
        for (TextBlock block : this.blocks) {
            HColor back;
            XDimension2D dimb = block.calculateDimension(ug.getStringBounder());
            if (block instanceof TextBlockBackcolored && (back = ((TextBlockBackcolored)block).getBackcolor()) != null && !back.isTransparent()) {
                ug.apply(UTranslate.dy(y)).apply(back).apply(back.bg()).draw(new URectangle(dimtotal.getWidth(), dimb.getHeight()));
            }
            if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
                block.drawU(ug.apply(UTranslate.dy(y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
                double dx = (dimtotal.getWidth() - dimb.getWidth()) / 2.0;
                block.drawU(ug.apply(new UTranslate(dx, y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                double dx = dimtotal.getWidth() - dimb.getWidth();
                block.drawU(ug.apply(new UTranslate(dx, y)));
            } else {
                throw new UnsupportedOperationException();
            }
            y += dimb.getHeight();
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        double y = 0.0;
        Ports result = new Ports();
        for (TextBlock block : this.blocks) {
            XDimension2D dimb = block.calculateDimension(stringBounder);
            Ports tmp = ((WithPorts)((Object)block)).getPorts(stringBounder).translateY(y);
            result.addThis(tmp);
            y += dimb.getHeight();
        }
        return result;
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        double y = 0.0;
        for (TextBlock block : this.blocks) {
            XDimension2D dimb = block.calculateDimension(stringBounder);
            XRectangle2D result = block.getInnerPosition(member, stringBounder, strategy);
            if (result != null) {
                return UTranslate.dy(y).apply(result);
            }
            y += dimb.getHeight();
        }
        return null;
    }
}

