/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.BodierJSon;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonParser;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateJsonSingleLine
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandCreateJsonSingleLine() {
        super(CommandCreateJsonSingleLine.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateJsonSingleLine.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "json"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DATA", "(\\{.*\\})"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String name = arg.get("NAME", 1);
        String data = arg.get("DATA", 0);
        IEntity entity1 = this.executeArg0(diagram, arg);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        JsonValue json = this.getJsonValue(data);
        if (json == null) {
            return CommandExecutionResult.error("Bad data");
        }
        ((BodierJSon)entity1.getBodier()).setJson(json);
        return CommandExecutionResult.ok();
    }

    private JsonValue getJsonValue(String data) {
        try {
            Json.DefaultHandler handler = new Json.DefaultHandler();
            new JsonParser(handler).parse(data);
            JsonValue json = handler.getValue();
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    private IEntity executeArg0(AbstractClassOrObjectDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s;
        boolean leafExist;
        String name = line0.get("NAME", 1);
        Ident ident = diagram.buildLeafIdent(name);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(name);
        String display = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        boolean bl = leafExist = diagram.V1972() ? diagram.leafExistSmart(ident) : diagram.leafExist(code);
        if (leafExist) {
            return diagram.getOrCreateLeaf(diagram.buildLeafIdent(name), code, LeafType.JSON, null);
        }
        ILeaf entity = diagram.createLeaf(ident, code, Display.getWithNewlines(display), LeafType.JSON, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        return entity;
    }
}

