/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.BodierMap;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateMap
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandCreateMap() {
        super(CommandCreateMap.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateMap.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "map"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreateMap.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("##"), new RegexLeaf("LINECOLOR", "(?:\\[(dotted|dashed|bold)\\])?(\\w+)?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        IEntity entity1 = this.executeArg0(diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        lines = lines.subExtract(1, 1);
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            boolean ok = entity1.getBodier().addFieldOrMethod(line);
            if (!ok) {
                return CommandExecutionResult.error("Map definition should contains key => value");
            }
            if (BodierMap.getLinkedEntry(line) == null) continue;
            String linkStr = BodierMap.getLinkedEntry(line);
            int x = line.indexOf(linkStr);
            String key = line.substring(0, x).trim();
            String dest = line.substring(x + linkStr.length()).trim();
            Ident ident2 = diagram.buildLeafIdentSpecial(dest);
            ILeaf entity2 = diagram.getEntityFactory().getLeafStrict(ident2);
            if (entity2 == null) {
                return CommandExecutionResult.error("No such entity " + ident2.getName());
            }
            LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
            int length = linkStr.length() - 2;
            Link link = new Link(diagram.getSkinParam().getCurrentStyleBuilder(), entity1, entity2, linkType, LinkArg.noDisplay(length));
            link.setPortMembers(key, null);
            diagram.addLink(link);
        }
        return CommandExecutionResult.ok();
    }

    private IEntity executeArg0(AbstractEntityDiagram diagram, RegexResult line0) throws NoSuchColorException {
        HColor lineColor;
        boolean leafExist;
        String name = line0.get("NAME", 1);
        Ident ident = diagram.buildLeafIdent(name);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(name);
        String display = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        boolean bl = leafExist = diagram.V1972() ? diagram.leafExistSmart(ident) : diagram.leafExist(code);
        if (leafExist) {
            return diagram.getOrCreateLeaf(diagram.buildLeafIdent(name), code, LeafType.MAP, null);
        }
        ILeaf entity = diagram.createLeaf(ident, code, Display.getWithNewlines(display), LeafType.MAP, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandCreateMap.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String s = line0.get("LINECOLOR", 1);
        HColor hColor = lineColor = s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (line0.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(line0.get("LINECOLOR", 0));
        }
        entity.setColors(colors);
        return entity;
    }
}

