/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security.authentication;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.security.authentication.SecurityCredentialsContainer;

public class SecurityCredentials
implements SecurityCredentialsContainer {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    public static final SecurityCredentials NONE = new SecurityCredentials("<NONE>", "public", null, null);
    private final String name;
    private final String type;
    private final String identifier;
    private final char[] secret;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Proxy proxy;

    public SecurityCredentials(String name, String type, String identifier, char[] secret) {
        this(name, type, identifier, secret, EMPTY_MAP, null);
    }

    public SecurityCredentials(String name, String type, String identifier, char[] secret, Map<String, Object> properties, Proxy proxy) {
        if (name == null) {
            throw new NullPointerException("Credential name should not be null");
        }
        this.name = name;
        this.type = type;
        this.identifier = identifier;
        this.secret = secret;
        this.proxy = proxy;
        this.properties.putAll(properties);
    }

    public static SecurityCredentials basicAuth(String identifier, char[] secret) {
        return new SecurityCredentials(identifier, "basicauth", identifier, secret);
    }

    public static SecurityCredentials fromJson(JsonValue jsonValue) {
        try {
            JsonObject securityObject = jsonValue.asObject();
            JsonValue name = securityObject.get("name");
            JsonValue type = securityObject.get("type");
            JsonValue identifier = securityObject.get("identifier");
            JsonValue secret = securityObject.get("secret");
            HashMap<String, Object> map = new HashMap<String, Object>();
            SecurityCredentials.buildProperties("", securityObject.get("properties"), map);
            if (type != null && !type.isNull() && "tokenauth".equals(type.asString())) {
                return new SecurityCredentials(name.asString(), "tokenauth", null, null, map, SecurityCredentials.proxyFromJson(securityObject.get("proxy")));
            }
            if (StringUtils.isNotEmpty(name.asString()) && StringUtils.isNotEmpty(identifier.asString())) {
                String authType = type != null && !type.isNull() ? type.asString() : "basicauth";
                return new SecurityCredentials(name.asString(), authType, identifier.asString(), SecurityCredentials.extractSecret(secret), map, SecurityCredentials.proxyFromJson(securityObject.get("proxy")));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return NONE;
    }

    private static Proxy proxyFromJson(JsonValue proxyValue) {
        if (proxyValue != null && !proxyValue.isNull() && proxyValue.isObject()) {
            Proxy.Type type = Proxy.Type.DIRECT;
            JsonObject proxyObject = proxyValue.asObject();
            JsonValue proxyType = proxyObject.get("type");
            if (proxyType != null && !proxyType.isNull()) {
                type = Proxy.Type.valueOf(proxyType.asString().toUpperCase());
            }
            if (type == Proxy.Type.DIRECT) {
                return Proxy.NO_PROXY;
            }
            JsonValue proxyAddress = proxyObject.get("address");
            JsonValue proxyPort = proxyObject.get("port");
            if (proxyAddress != null && !proxyAddress.isNull() && !proxyPort.isNull() && proxyPort.isNumber()) {
                InetSocketAddress address = new InetSocketAddress(proxyAddress.asString(), proxyPort.asInt());
                return new Proxy(type, address);
            }
        }
        return null;
    }

    private static char[] extractSecret(JsonValue pwd) {
        if (pwd == null || pwd.isNull()) {
            return null;
        }
        String pwdStr = pwd.asString();
        if (StringUtils.isEmpty(pwdStr)) {
            return null;
        }
        return pwdStr.toCharArray();
    }

    private static void buildProperties(String prefix, JsonValue fromValue, Map<String, Object> toMap) {
        if (!SecurityCredentials.isJsonObjectWithMembers(fromValue)) {
            return;
        }
        JsonObject members = fromValue.asObject();
        for (String name : members.names()) {
            String key;
            JsonValue child = members.get(name);
            if (child.isArray() || child.isNull()) continue;
            String string = key = StringUtils.isEmpty(prefix) ? name : prefix + "." + name;
            if (child.isObject()) {
                SecurityCredentials.buildProperties(key, child, toMap);
                continue;
            }
            if (child.isString()) {
                toMap.put(key, child.asString());
                continue;
            }
            if (child.isBoolean()) {
                toMap.put(key, child.asBoolean());
                continue;
            }
            if (!child.isNumber()) continue;
            toMap.put(key, child.asDouble());
        }
    }

    private static boolean isJsonObjectWithMembers(JsonValue jsonValue) {
        return jsonValue != null && !jsonValue.isNull() && jsonValue.isObject() && !jsonValue.asObject().isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public char[] getSecret() {
        return this.secret;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getPropertyStr(String key) {
        Object value = this.getProperties().get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public char[] getPropertyChars(String key) {
        Object value = this.getProperties().get(key);
        if (value != null) {
            return value.toString().toCharArray();
        }
        return null;
    }

    public boolean getPropertyBool(String key) {
        Object value = this.getProperties().get(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return false;
    }

    public Number getPropertyNum(String key) {
        Object value = this.getProperties().get(key);
        if (value != null) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
        }
        return null;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void eraseCredentials() {
        if (this.secret != null && this.secret.length > 0) {
            Arrays.fill(this.secret, '*');
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityCredentials)) {
            return false;
        }
        SecurityCredentials that = (SecurityCredentials)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

