/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.CucaNote;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterDotString;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class Cluster
implements Moveable {
    static final String RANK_SOURCE = "source";
    static final String RANK_SINK = "sink";
    public static final String CENTER_ID = "za";
    private final Cluster parentCluster;
    private final IGroup group;
    private final List<SvekNode> nodes = new ArrayList<SvekNode>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final int colorNoteTop;
    private final int colorNoteBottom;
    private final ISkinParam skinParam;
    protected final CucaDiagram diagram;
    private ClusterHeader clusterHeader;
    private XPoint2D xyTitle;
    private XPoint2D xyNoteTop;
    private XPoint2D xyNoteBottom;
    private ClusterPosition clusterPosition;

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        if (this.xyNoteTop != null) {
            this.xyNoteTop = this.xyNoteTop.move(deltaX, deltaY);
        }
        if (this.xyNoteBottom != null) {
            this.xyNoteBottom = this.xyNoteBottom.move(deltaX, deltaY);
        }
        if (this.xyTitle != null) {
            this.xyTitle = this.xyTitle.move(deltaX, deltaY);
        }
        if (this.clusterPosition != null) {
            this.clusterPosition = this.clusterPosition.move(deltaX, deltaY);
        }
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (SvekNode sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    public Cluster(CucaDiagram diagram, ColorSequence colorSequence, ISkinParam skinParam, IGroup root) {
        this(diagram, null, colorSequence, skinParam, root);
    }

    private Cluster(CucaDiagram diagram, Cluster parentCluster, ColorSequence colorSequence, ISkinParam skinParam, IGroup group) {
        if (group == null) {
            throw new IllegalStateException();
        }
        this.parentCluster = parentCluster;
        this.group = group;
        this.diagram = diagram;
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.colorNoteTop = colorSequence.getValue();
        this.colorNoteBottom = colorSequence.getValue();
        this.skinParam = group.getColors().mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParentCluster() {
        return this.parentCluster;
    }

    public void addNode(SvekNode node) {
        this.nodes.add(Objects.requireNonNull(node));
        node.setCluster(this);
    }

    public final List<SvekNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public final List<SvekNode> getNodes(EnumSet<EntityPosition> position) {
        ArrayList<SvekNode> result = new ArrayList<SvekNode>();
        for (SvekNode node : this.nodes) {
            if (!position.contains((Object)node.getEntityPosition())) continue;
            result.add(node);
        }
        return Collections.unmodifiableList(result);
    }

    private List<SvekNode> getNodesOrderedTop(Collection<SvekLine> lines) {
        ArrayList<SvekNode> firsts = new ArrayList<SvekNode>();
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        for (SvekNode node : this.nodes) {
            shs.put(node.getUid(), node);
        }
        for (SvekLine l : lines) {
            SvekNode sh;
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null || sh.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(0, sh);
        }
        return firsts;
    }

    private List<SvekNode> getNodesOrderedWithoutTop(Collection<SvekLine> lines) {
        ArrayList<SvekNode> all = new ArrayList<SvekNode>(this.nodes);
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            SvekNode sh = (SvekNode)it.next();
            if (sh.getEntityPosition() != EntityPosition.NORMAL) {
                it.remove();
                continue;
            }
            shs.put(sh.getUid(), sh);
        }
        for (SvekLine l : lines) {
            SvekNode sh;
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null) continue;
            all.remove(sh);
        }
        return all;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(ClusterHeader clusterHeader, ColorSequence colorSequence, ISkinParam skinParam, IGroup g) {
        Cluster child = new Cluster(this.diagram, this, colorSequence, skinParam, g);
        child.clusterHeader = clusterHeader;
        this.children.add(child);
        return child;
    }

    public final Set<IGroup> getGroups() {
        return Collections.singleton(this.group);
    }

    final IGroup getGroup() {
        return this.group;
    }

    public final int getTitleAndAttributeWidth() {
        return this.clusterHeader.getTitleAndAttributeWidth();
    }

    public final int getTitleAndAttributeHeight() {
        return this.clusterHeader.getTitleAndAttributeHeight();
    }

    public ClusterPosition getClusterPosition() {
        return this.clusterPosition;
    }

    public void setTitlePosition(XPoint2D pos) {
        this.xyTitle = pos;
    }

    public void setNoteTopPosition(XPoint2D pos) {
        this.xyNoteTop = pos;
    }

    public void setNoteBottomPosition(XPoint2D pos) {
        this.xyNoteBottom = pos;
    }

    public static StyleSignatureBasic getDefaultStyleDefinition(SName diagramStyleName, USymbol symbol) {
        if (diagramStyleName == SName.stateDiagram) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.group);
        }
        if (symbol == null) {
            return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group, symbol.getSName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, UmlDiagramType umlDiagramType, ISkinParam skinParam2unused) {
        String fullName;
        if (this.group.isHidden()) {
            return;
        }
        if (this.diagram.getPragma().useKermor()) {
            if (this.xyNoteTop != null) {
                this.getCucaNote(Position.TOP).drawU(ug.apply(new UTranslate(this.xyNoteTop)));
            }
            if (this.xyNoteBottom != null) {
                this.getCucaNote(Position.BOTTOM).drawU(ug.apply(new UTranslate(this.xyNoteBottom)));
            }
        }
        if (!(fullName = this.group.getCodeGetName()).startsWith("##")) {
            ug.draw(new UComment("cluster " + fullName));
        }
        USymbol uSymbol = this.group.getUSymbol() == null ? USymbols.PACKAGE : this.group.getUSymbol();
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), uSymbol).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        double shadowing = style.value(PName.Shadowing).asDouble();
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE) != null ? this.group.getColors().getColor(ColorType.LINE) : style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double rounded = style.value(PName.RoundCorner).asDouble();
        double diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        ug.startGroup(Collections.singletonMap(UGroupType.ID, "cluster_" + fullName));
        Url url = this.group.getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        try {
            boolean isState;
            if (this.entityPositionsExceptNormal().size() > 0) {
                this.manageEntryExitPoint(ug.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(umlDiagramType)) {
                this.drawSwinLinesState(ug, borderColor);
                return;
            }
            boolean bl = isState = umlDiagramType == UmlDiagramType.STATE;
            if (isState && this.group.getUSymbol() == null) {
                this.drawUState(ug, umlDiagramType, rounded, shadowing);
                return;
            }
            PackageStyle packageStyle = this.group.getPackageStyle();
            if (packageStyle == null) {
                packageStyle = this.skinParam.packageStyle();
            }
            UStroke stroke = Cluster.getStrokeInternal(this.group, style);
            HColor backColor = this.getBackColor(umlDiagramType, style);
            backColor = Cluster.getBackColor(backColor, this.group.getStereotype(), umlDiagramType.getStyleName(), this.group.getUSymbol(), this.skinParam.getCurrentStyleBuilder(), this.skinParam.getIHtmlColorSet());
            ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.clusterHeader.getTitle(), this.clusterHeader.getStereo(), this.clusterPosition, stroke);
            decoration.drawU(ug, backColor, borderColor, shadowing, rounded, this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), this.skinParam.getStereotypeAlignment(), diagonalCorner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (url != null) {
                ug.closeUrl();
            }
            ug.closeGroup();
        }
    }

    EntityImageNoteLink getCucaNote(Position position) {
        List<CucaNote> notes = this.getGroup().getNotes(position);
        if (notes.size() == 0) {
            return null;
        }
        CucaNote note = notes.get(0);
        return new EntityImageNoteLink(note.getDisplay(), note.getColors(), this.skinParam, this.skinParam.getCurrentStyleBuilder());
    }

    public static UStroke getStrokeInternal(IGroup group, Style style) {
        Colors colors = group.getColors();
        if (colors.getSpecificLineStroke() != null) {
            return colors.getSpecificLineStroke();
        }
        return style.getStroke();
    }

    void manageEntryExitPoint(StringBounder stringBounder) {
        ArrayList<ClusterPosition> insides = new ArrayList<ClusterPosition>();
        ArrayList<XPoint2D> points = new ArrayList<XPoint2D>();
        for (SvekNode sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) {
                insides.add(sh.getClusterPosition());
                continue;
            }
            points.add(sh.getClusterPosition().getPointCenter());
        }
        for (Cluster in : this.children) {
            insides.add(in.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), insides, points);
        if (this.getTitleAndAttributeWidth() > 0 && this.getTitleAndAttributeHeight() > 0) {
            frontierCalculator.ensureMinWidth(this.getTitleAndAttributeWidth() + 10);
        }
        this.clusterPosition = frontierCalculator.getSuggestedPosition();
        double widthTitle = this.clusterHeader.getTitle().calculateDimension(stringBounder).getWidth();
        double minX = this.clusterPosition.getMinX();
        double minY = this.clusterPosition.getMinY();
        this.xyTitle = new XPoint2D(minX + (this.clusterPosition.getWidth() - widthTitle) / 2.0, minY + 5.0);
    }

    private void drawSwinLinesState(UGraphic ug, HColor borderColor) {
        this.clusterHeader.getTitle().drawU(ug.apply(UTranslate.dx(this.xyTitle.x)));
        ULine line = ULine.vline(this.clusterPosition.getHeight());
        ug = ug.apply(borderColor);
        ug.apply(UTranslate.dx(this.clusterPosition.getMinX())).draw(line);
        ug.apply(UTranslate.dx(this.clusterPosition.getMaxX())).draw(line);
    }

    private void drawUState(UGraphic ug, UmlDiagramType umlDiagramType, double rounded, double shadowing) {
        Stereotype stereotype;
        boolean withSymbol;
        HColor backColor;
        XDimension2D total = this.clusterPosition.getDimension();
        double suppY = this.clusterHeader.getTitle().calculateDimension(ug.getStringBounder()).getHeight() + 5.0;
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = EntityImageStateCommon.getStyleState(this.group, this.skinParam).value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        if ((backColor = this.group.getColors().getColor(ColorType.BACK)) == null) {
            backColor = EntityImageStateCommon.getStyleState(this.group, this.skinParam).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        HColor imgBackcolor = EntityImageStateCommon.getStyleStateBody(this.group, this.skinParam).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        TextBlock attribute = ((EntityImpl)this.group).getStateHeader(this.skinParam);
        double attributeHeight = attribute.calculateDimension(ug.getStringBounder()).getHeight();
        if (total.getWidth() == 0.0) {
            System.err.println("Cluster::drawUState issue");
            return;
        }
        UStroke stroke = this.group.getColors().getSpecificLineStroke();
        if (stroke == null) {
            stroke = EntityImageStateCommon.getStyleState(this.group, this.skinParam).getStroke();
        }
        RoundedContainer r = new RoundedContainer(total, suppY, attributeHeight + (double)(attributeHeight > 0.0 ? 5 : 0), borderColor, backColor, imgBackcolor, stroke, rounded, shadowing);
        r.drawU(ug.apply(this.clusterPosition.getPosition()));
        this.clusterHeader.getTitle().drawU(ug.apply(new UTranslate(this.xyTitle)));
        if (attributeHeight > 0.0) {
            attribute.drawU(ug.apply(new UTranslate(this.clusterPosition.getMinX() + 5.0, this.clusterPosition.getMinY() + suppY + 2.5)));
        }
        boolean bl = withSymbol = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (withSymbol) {
            EntityImageState.drawSymbol(ug.apply(borderColor), this.clusterPosition.getMaxX(), this.clusterPosition.getMaxY());
        }
    }

    public void setPosition(XPoint2D min, XPoint2D max) {
        this.clusterPosition = new ClusterPosition(min, max);
    }

    public boolean printCluster1(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder) {
        List<SvekNode> tmp = this.getNodesOrderedTop(lines);
        if (tmp.size() == 0) {
            return false;
        }
        for (SvekNode node : tmp) {
            node.appendShape(sb, stringBounder);
        }
        return true;
    }

    public SvekNode printCluster2(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        SvekNode added = null;
        for (SvekNode node : this.getNodesOrderedWithoutTop(lines)) {
            node.appendShape(sb, stringBounder);
            added = node;
        }
        if (this.skinParam.useRankSame() && dotMode != DotMode.NO_LEFT_RIGHT_AND_XLABEL && !graphvizVersion.ignoreHorizontalLinks()) {
            this.appendRankSame(sb, lines);
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        return added;
    }

    public void printCluster3_forKermor(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        List<SvekNode> tmp = this.getNodes(EntityPosition.getNormals());
        if (tmp.size() == 0) {
            sb.append(this.getClusterId() + "empty [shape=point,label=\"\"];");
            SvekUtils.println(sb);
        } else {
            for (SvekNode node : tmp) {
                node.appendShape(sb, stringBounder);
            }
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
    }

    private void printInternal(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        new ClusterDotString(this, this.skinParam).printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
    }

    private void appendRankSame(StringBuilder sb, Collection<SvekLine> lines) {
        for (String same : this.getRankSame(lines)) {
            sb.append(same);
            SvekUtils.println(sb);
        }
    }

    private Set<String> getRankSame(Collection<SvekLine> lines) {
        HashSet<String> rankSame = new HashSet<String>();
        for (SvekLine l : lines) {
            String same;
            if (l.hasEntryPoint()) continue;
            String startUid = l.getStartUidPrefix();
            String endUid = l.getEndUidPrefix();
            if (!this.isInCluster(startUid) || !this.isInCluster(endUid) || (same = l.rankSame()) == null) continue;
            rankSame.add(same);
        }
        return rankSame;
    }

    private boolean isInCluster(String uid) {
        for (SvekNode node : this.nodes) {
            if (!node.getUid().equals(uid)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    static String getSpecialPointId(IEntity group) {
        return CENTER_ID + group.getUid();
    }

    String getMinPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    String getMaxPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    public boolean isLabel() {
        return this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
    }

    int getColor() {
        return this.color;
    }

    int getTitleColor() {
        return this.colorTitle;
    }

    private final HColor getBackColor(UmlDiagramType umlDiagramType, Style style) {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HColor result = this.group.getColors().getColor(ColorType.BACK);
        if (result != null) {
            return result;
        }
        Stereotype stereo = this.group.getStereotype();
        return style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    boolean isClusterOf(IEntity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        return this.group == ent;
    }

    public static HColor getBackColor(HColor backColor, Stereotype stereotype, SName styleName, USymbol symbol, StyleBuilder styleBuilder, HColorSet colorSet) {
        Style style = Cluster.getDefaultStyleDefinition(styleName, symbol).getMergedStyle(styleBuilder);
        if (backColor == null) {
            backColor = style.value(PName.BackGroundColor).asColor(colorSet);
        }
        if (backColor == null || backColor.equals(HColors.transparent())) {
            backColor = HColors.transparent();
        }
        return backColor;
    }

    double checkFolderPosition(XPoint2D pt, StringBounder stringBounder) {
        if (this.getClusterPosition().isPointJustUpper(pt)) {
            XDimension2D dimTitle = this.clusterHeader.getTitle().calculateDimension(stringBounder);
            if (pt.getX() < this.getClusterPosition().getMinX() + dimTitle.getWidth()) {
                return 0.0;
            }
            return this.getClusterPosition().getMinY() - pt.getY() + dimTitle.getHeight();
        }
        return 0.0;
    }

    public final int getColorNoteTop() {
        return this.colorNoteTop;
    }

    public final int getColorNoteBottom() {
        return this.colorNoteBottom;
    }

    public XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.clusterHeader.getTitle().calculateDimension(stringBounder);
    }
}

