/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageDegenerated
implements IEntityImage {
    private final IEntityImage orig;
    private final double delta = 7.0;
    private final HColor backcolor;

    public EntityImageDegenerated(IEntityImage orig, HColor backcolor) {
        this.orig = orig;
        this.backcolor = backcolor;
    }

    @Override
    public boolean isHidden() {
        return this.orig.isHidden();
    }

    @Override
    public HColor getBackcolor() {
        return this.backcolor;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return XDimension2D.delta(this.orig.calculateDimension(stringBounder), 14.0, 14.0);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        return this.orig.getMinMax(stringBounder);
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.orig.getInnerPosition(member, stringBounder, strategy);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.orig.drawU(ug.apply(new UTranslate(7.0, 7.0)));
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug.apply(new UTranslate(dim.getWidth() - 7.0, dim.getHeight() - 7.0)).draw(new UEmpty(7.0, 7.0));
    }

    @Override
    public ShapeType getShapeType() {
        return this.orig.getShapeType();
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.orig.getShield(stringBounder);
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return this.orig.getOverscanX(stringBounder);
    }
}

