/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class ExtremityArrow
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final ULine line;
    private final XPoint2D contact;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityArrow(XPoint2D p1, double angle, XPoint2D center) {
        angle = this.manageround(angle);
        int xContact = this.buildPolygon();
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
        this.contact = new XPoint2D(p1.getX() - (double)xContact * Math.cos(angle + 1.5707963267948966), p1.getY() - (double)xContact * Math.sin(angle + 1.5707963267948966));
        this.line = new ULine(center.getX() - this.contact.getX(), center.getY() - this.contact.getY());
    }

    public ExtremityArrow(XPoint2D p0, double angle) {
        this.line = null;
        angle = this.manageround(angle);
        this.buildPolygon();
        this.polygon.rotate(angle);
        this.polygon = this.polygon.translate(p0.getX(), p0.getY());
        this.contact = p0;
    }

    private int buildPolygon() {
        this.polygon.addPoint(0.0, 0.0);
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        return 5;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = ug.getParam().getColor();
        ug = color == null ? ug.apply(HColors.none().bg()) : ug.apply(color.bg());
        ug.draw(this.polygon);
        if (this.line != null && this.line.getLength() > 2.0) {
            ug.apply(new UTranslate(this.contact)).draw(this.line);
        }
    }
}

