/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageArcCircle
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;

    public EntityImageArcCircle(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.name = entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.COMPONENT, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null ? null : Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimName = this.name.calculateDimension(stringBounder);
        XDimension2D dimStereo = this.getStereoDimension(stringBounder);
        return XDimension2D.mergeTB(dimStereo, dimName);
    }

    private XDimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new XDimension2D(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimStereo = this.getStereoDimension(stringBounder);
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimName = this.name.calculateDimension(stringBounder);
        double nameX = (dimTotal.getWidth() - dimName.getWidth()) / 2.0;
        double nameY = dimStereo.getHeight();
        this.name.drawU(ug.apply(new UTranslate(nameX, nameY)));
        if (this.stereo != null) {
            double stereoX = (dimTotal.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(UTranslate.dx(stereoX)));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

