/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageAssociationPoint
extends AbstractEntityImage {
    private static final int SIZE = 4;

    public EntityImageAssociationPoint(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(4.0, 4.0);
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.arrow).withTOBECHANGED(this.getStereo()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(4.0, 4.0);
        HColor color = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        ug.apply(color).apply(new CopyForegroundColorToBackgroundColor()).draw(circle);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

