/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.image.ConnectedCircle;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class EntityImageLollipopInterfaceEye1
extends AbstractEntityImage {
    private static final int SIZE = 24;
    private final TextBlock desc;
    private final Bibliotekon bibliotekon;
    private final Url url;

    public EntityImageLollipopInterfaceEye1(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder));
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground).bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        double sizeSmall = 14.0;
        double diff = 5.0;
        UEllipse circle1 = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            // empty if block
        }
        ug.apply(new UStroke(1.5)).apply(new UTranslate(5.0, 5.0)).draw(circle1);
        ug = ug.apply(HColors.none().bg());
        XPoint2D pos = this.bibliotekon.getNode(this.getEntity()).getPosition();
        List<SvekLine> lines = this.bibliotekon.getAllLineConnectedTo(this.getEntity());
        UTranslate reverse = new UTranslate(pos).reverse();
        ConnectedCircle connectedCircle = new ConnectedCircle(12.0);
        for (SvekLine line : lines) {
            XPoint2D pt = line.getMyPoint(this.getEntity());
            pt = reverse.getTranslated(pt);
            connectedCircle.addSecondaryConnection(pt);
        }
        connectedCircle.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

