/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImagePort
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImagePort(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, parent, bibliotekon, FontParam.BOUNDARY);
        this.sname = sname;
    }

    private StyleSignature getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.port).withTOBECHANGED(this.getStereo());
    }

    private boolean upPosition() {
        XPoint2D clusterCenter = this.parent.getClusterPosition().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double sp = 12.0;
        return new XDimension2D(sp, sp);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        XDimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    private void drawSymbol(UGraphic ug) {
        URectangle rect = new URectangle(12.0, 12.0);
        ug.draw(rect);
    }

    @Override
    public final void drawU(UGraphic ug) {
        double y = 0.0;
        XDimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor borderColor = this.getEntity().getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(borderColor);
        ug = ug.apply(this.getUStroke()).apply(backcolor.bg());
        this.drawSymbol(ug);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE_PORT;
    }
}

