/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class EntityImageStateCommon
extends AbstractEntityImage {
    protected final TextBlock title;
    protected final Url url;
    protected final LineConfigurable lineConfig;

    public EntityImageStateCommon(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.lineConfig = entity;
        FontConfiguration titleFontConfiguration = EntityImageStateCommon.getStyleStateTitle(entity, skinParam).getFontConfiguration(this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        this.title = entity.getDisplay().create8(titleFontConfiguration, HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
        this.url = entity.getUrl99();
    }

    public static Style getStyleStateTitle(IEntity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.title).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleStateHeader(IEntity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.header).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleState(IEntity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleStateBody(IEntity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.stateBody).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    protected final Style getStyleState() {
        return EntityImageStateCommon.getStyleState(this.getEntity(), this.getSkinParam());
    }

    protected final Style getStyleStateHeader() {
        return EntityImageStateCommon.getStyleStateHeader(this.getEntity(), this.getSkinParam());
    }

    @Override
    public final ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    protected final URectangle getShape(XDimension2D dimTotal) {
        double corner = this.getStyleState().value(PName.RoundCorner).asDouble();
        double deltaShadow = this.getStyleState().value(PName.Shadowing).asDouble();
        URectangle rect = new URectangle(dimTotal).rounded(corner);
        rect.setDeltaShadow(deltaShadow);
        return rect;
    }

    protected final UGraphic applyColor(UGraphic ug) {
        HColor border = this.lineConfig.getColors().getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyleState().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = this.lineConfig.getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyleState().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }
}

