/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateEmptyDescription
extends EntityImageStateCommon {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 40;

    public EntityImageStateEmptyDescription(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.title.calculateDimension(stringBounder);
        XDimension2D result = XDimension2D.delta(dim, 10.0);
        return XDimension2D.atLeast(result, 50.0, 40.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimDesc = this.title.calculateDimension(stringBounder);
        UStroke stroke = this.getStyleState().getStroke(this.lineConfig.getColors());
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        double xDesc = (dimTotal.getWidth() - dimDesc.getWidth()) / 2.0;
        double yDesc = (dimTotal.getHeight() - dimDesc.getHeight()) / 2.0;
        this.title.drawU(ug.apply(new UTranslate(xDesc, yDesc)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

