/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPattern;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public abstract class AbstractCommonUGraphic
implements UGraphic {
    private UStroke stroke = new UStroke();
    private UPattern pattern = UPattern.FULL;
    private boolean hidden = false;
    private HColor backColor = HColors.none();
    private HColor color = HColors.none();
    private boolean enlargeClip = false;
    private final StringBounder stringBounder;
    private UTranslate translate = new UTranslate();
    private final ColorMapper colorMapper;
    private UClip clip;
    private final HColor defaultBackground;

    @Override
    public HColor getDefaultBackground() {
        return this.defaultBackground;
    }

    public double dpiFactor() {
        return 1.0;
    }

    @Override
    public UGraphic apply(UChange change) {
        Objects.requireNonNull(change);
        AbstractCommonUGraphic copy = this.copyUGraphic();
        if (change instanceof UTranslate) {
            copy.translate = ((UTranslate)change).compose(copy.translate);
        } else if (change instanceof UClip) {
            copy.clip = (UClip)change;
            copy.clip = copy.clip.translate(this.getTranslateX(), this.getTranslateY());
        } else if (change instanceof UStroke) {
            copy.stroke = (UStroke)change;
        } else if (change instanceof UPattern) {
            copy.pattern = (UPattern)change;
        } else if (change instanceof UHidden) {
            copy.hidden = change == UHidden.HIDDEN;
        } else if (change instanceof UBackground) {
            copy.backColor = ((UBackground)change).getBackColor();
        } else if (change instanceof HColor) {
            copy.color = (HColor)change;
        } else if (change instanceof CopyForegroundColorToBackgroundColor) {
            copy.backColor = this.color;
        }
        return copy;
    }

    public final UClip getClip() {
        if (this.enlargeClip && this.clip != null) {
            return this.clip.enlarge(1.0);
        }
        return this.clip;
    }

    public final void enlargeClip() {
        this.enlargeClip = true;
    }

    public AbstractCommonUGraphic(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder) {
        if (defaultBackground == null) {
            throw new IllegalArgumentException();
        }
        this.colorMapper = colorMapper;
        this.defaultBackground = defaultBackground;
        this.stringBounder = stringBounder;
    }

    protected AbstractCommonUGraphic(AbstractCommonUGraphic other) {
        this.defaultBackground = other.defaultBackground;
        if (this.defaultBackground == null) {
            throw new IllegalArgumentException();
        }
        this.enlargeClip = other.enlargeClip;
        this.colorMapper = other.colorMapper;
        this.stringBounder = other.stringBounder;
        this.translate = other.translate;
        this.clip = other.clip;
        this.stroke = other.stroke;
        this.pattern = other.pattern;
        this.hidden = other.hidden;
        this.color = other.color;
        this.backColor = other.backColor;
    }

    protected abstract AbstractCommonUGraphic copyUGraphic();

    @Override
    public final UParam getParam() {
        return new UParam(){

            @Override
            public boolean isHidden() {
                return AbstractCommonUGraphic.this.hidden;
            }

            @Override
            public UStroke getStroke() {
                return AbstractCommonUGraphic.this.stroke;
            }

            @Override
            public HColor getColor() {
                return AbstractCommonUGraphic.this.color;
            }

            @Override
            public HColor getBackcolor() {
                return AbstractCommonUGraphic.this.backColor;
            }

            @Override
            public UPattern getPattern() {
                return AbstractCommonUGraphic.this.pattern;
            }
        };
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final double getTranslateX() {
        return this.translate.getDx();
    }

    protected final double getTranslateY() {
        return this.translate.getDy();
    }

    @Override
    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    @Override
    public final void flushUg() {
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeUrl() {
    }

    @Override
    public void startGroup(Map<UGroupType, String> typeIdents) {
    }

    @Override
    public void closeGroup() {
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }
}

