/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShapeIgnorableForCompression;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;

public class UPath
extends AbstractShadowable
implements Iterable<USegment>,
UShapeIgnorableForCompression {
    private final String comment;
    private final String codeLine;
    private final List<USegment> segments = new ArrayList<USegment>();
    private MinMax minmax = MinMax.getEmpty(false);
    private boolean isOpenIconic;
    private boolean ignoreForCompressionOnX;
    private boolean ignoreForCompressionOnY;

    public UPath(String comment, String codeLine) {
        this.comment = comment;
        this.codeLine = codeLine;
    }

    public UPath() {
        this(null, null);
    }

    public void add(double[] coord, USegmentType pathType) {
        this.addInternal(new USegment(coord, pathType));
    }

    public boolean isEmpty() {
        return this.segments.size() == 0;
    }

    private void addInternal(USegment segment) {
        this.segments.add(segment);
        double[] coord = segment.getCoord();
        if (segment.getSegmentType() == USegmentType.SEG_ARCTO) {
            this.minmax = this.minmax.addPoint(coord[5], coord[6]);
        } else {
            for (int i = 0; i < coord.length; i += 2) {
                this.minmax = this.minmax.addPoint(coord[i], coord[i + 1]);
            }
        }
    }

    public UPath translate(double dx, double dy) {
        UPath result = new UPath(this.comment, this.codeLine);
        for (USegment seg : this.segments) {
            result.addInternal(seg.translate(dx, dy));
        }
        return result;
    }

    public UPath rotate(double theta) {
        UPath result = new UPath(this.comment, this.codeLine);
        for (USegment seg : this.segments) {
            result.addInternal(seg.rotate(theta));
        }
        return result;
    }

    public void moveTo(XPoint2D pt) {
        this.moveTo(pt.getX(), pt.getY());
    }

    public void lineTo(XPoint2D pt) {
        this.lineTo(pt.getX(), pt.getY());
    }

    public void moveTo(double x, double y) {
        this.add(new double[]{x, y}, USegmentType.SEG_MOVETO);
    }

    public void lineTo(double x, double y) {
        this.add(new double[]{x, y}, USegmentType.SEG_LINETO);
    }

    public void cubicTo(XPoint2D p1, XPoint2D p2, XPoint2D p) {
        this.cubicTo(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p.getX(), p.getY());
    }

    public void cubicTo(double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        this.add(new double[]{ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(double ctrlx, double ctrly, double x2, double y2) {
        this.add(new double[]{ctrlx, ctrly, ctrlx, ctrly, x2, y2}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(XPoint2D ctrl, XPoint2D pt) {
        this.quadTo(ctrl.getX(), ctrl.getY(), pt.getX(), pt.getY());
    }

    public void arcTo(double rx, double ry, double x_axis_rotation, double large_arc_flag, double sweep_flag, double x, double y) {
        this.add(new double[]{rx, ry, x_axis_rotation, large_arc_flag, sweep_flag, x, y}, USegmentType.SEG_ARCTO);
    }

    public void arcTo(XPoint2D pt, double radius, double large_arc_flag, double sweep_flag) {
        this.add(new double[]{radius, radius, 0.0, large_arc_flag, sweep_flag, pt.getX(), pt.getY()}, USegmentType.SEG_ARCTO);
    }

    public void closePath() {
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public String toString() {
        return this.segments.toString();
    }

    @Override
    public Iterator<USegment> iterator() {
        return this.segments.iterator();
    }

    public boolean isOpenIconic() {
        return this.isOpenIconic;
    }

    public void setOpenIconic(boolean isOpenIconic) {
        this.isOpenIconic = isOpenIconic;
    }

    public final String getComment() {
        return this.comment;
    }

    public final String getCodeLine() {
        return this.codeLine;
    }

    public void setIgnoreForCompressionOnX() {
        this.ignoreForCompressionOnX = true;
    }

    public void setIgnoreForCompressionOnY() {
        this.ignoreForCompressionOnY = true;
    }

    @Override
    public void drawWhenCompressed(UGraphic ug, CompressionMode mode) {
    }

    @Override
    public boolean isIgnoreForCompressionOn(CompressionMode mode) {
        if (mode == CompressionMode.ON_X) {
            return this.ignoreForCompressionOnX;
        }
        if (mode == CompressionMode.ON_Y) {
            return this.ignoreForCompressionOnY;
        }
        throw new IllegalArgumentException();
    }
}

