/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.USegmentType;

public class USegment {
    private final double[] coord;
    private final USegmentType pathType;

    public USegment(double[] coord, USegmentType pathType) {
        this.coord = (double[])coord.clone();
        this.pathType = pathType;
    }

    public String toString() {
        return this.pathType.toString() + " " + Arrays.toString(this.coord);
    }

    public final double[] getCoord() {
        return this.coord;
    }

    public final USegmentType getSegmentType() {
        return this.pathType;
    }

    public USegment translate(double dx, double dy) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        XPoint2D p1 = new XPoint2D(this.coord[0] + dx, this.coord[1] + dy);
        return new USegment(new double[]{p1.getX(), p1.getY()}, this.pathType);
    }

    public USegment rotate(double theta) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        XPoint2D p1 = new XPoint2D(this.coord[0], this.coord[1]);
        AffineTransform rotate = AffineTransform.getRotateInstance(theta);
        p1 = p1.transform(rotate);
        return new USegment(new double[]{p1.getX(), p1.getY()}, this.pathType);
    }
}

