/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.svg.DriverCenteredCharacterSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverDotPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverEllipseSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverImagePng;
import net.sourceforge.plantuml.ugraphic.svg.DriverImageSvgSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverLineSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPixelSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPolygonSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextAsPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextSvg;

public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer {
    private final boolean textAsPath2;
    private final String target;
    private final boolean interactive;

    @Override
    public double dpiFactor() {
        return 1.0;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicSvg(this);
    }

    private UGraphicSvg(UGraphicSvg other) {
        super(other);
        this.textAsPath2 = other.textAsPath2;
        this.target = other.target;
        this.interactive = other.interactive;
        this.register();
    }

    public UGraphicSvg(HColor defaultBackground, boolean svgDimensionStyle, XDimension2D minDim, ColorMapper colorMapper, boolean textAsPath, double scale, String linkTarget, String hover, long seed, String preserveAspectRatio, StringBounder stringBounder, LengthAdjust lengthAdjust, boolean interactive) {
        this(defaultBackground, minDim, colorMapper, new SvgGraphics(defaultBackground.toSvg(colorMapper), svgDimensionStyle, minDim, scale, hover, seed, preserveAspectRatio, lengthAdjust, interactive), textAsPath, linkTarget, stringBounder, interactive);
        if (defaultBackground instanceof HColorGradient) {
            SvgGraphics svg = (SvgGraphics)this.getGraphicObject();
            svg.paintBackcolorGradient(colorMapper, (HColorGradient)defaultBackground);
        }
    }

    @Override
    protected boolean manageHiddenAutomatically() {
        return false;
    }

    @Override
    protected void beforeDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(this.getParam().isHidden());
    }

    @Override
    protected void afterDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(false);
    }

    private UGraphicSvg(HColor defaultBackground, XDimension2D minDim, ColorMapper colorMapper, SvgGraphics svg, boolean textAsPath, String linkTarget, StringBounder stringBounder, boolean interactive) {
        super(defaultBackground, colorMapper, stringBounder, svg);
        this.textAsPath2 = textAsPath;
        this.target = linkTarget;
        this.interactive = interactive;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        if (this.textAsPath2) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPixel.class, new DriverPixelSvg());
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg(this));
        this.registerDriver(UImage.class, new DriverImagePng(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
        this.registerDriver(DotPath.class, new DriverDotPathSvg());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterSvg());
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        try {
            if (metadata != null) {
                ((SvgGraphics)this.getGraphicObject()).addComment(metadata);
            }
            if (this.interactive) {
                ((SvgGraphics)this.getGraphicObject()).addStyle("onmouseinteractivefooter.css");
                ((SvgGraphics)this.getGraphicObject()).addScriptTag("https://cdn.jsdelivr.net/npm/@svgdotjs/svg.js@3.0/dist/svg.min.js");
                ((SvgGraphics)this.getGraphicObject()).addScript("onmouseinteractivefooter.js");
            }
            ((SvgGraphics)this.getGraphicObject()).createXml(os);
        }
        catch (TransformerException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void startGroup(Map<UGroupType, String> typeIdents) {
        ((SvgGraphics)this.getGraphicObject()).startGroup(typeIdents);
    }

    @Override
    public void closeGroup() {
        ((SvgGraphics)this.getGraphicObject()).closeGroup();
    }

    @Override
    public void startUrl(Url url) {
        ((SvgGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip(), this.target);
    }

    @Override
    public void closeUrl() {
        ((SvgGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    protected void drawComment(UComment comment) {
        ((SvgGraphics)this.getGraphicObject()).addComment(comment.getComment());
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        if (propertyName.equalsIgnoreCase("SVG")) {
            return true;
        }
        return super.matchesProperty(propertyName);
    }
}

