/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItem
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSItem() {
        super(false, CommandWBSItem.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSItem.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = type.contains("-") ? Direction.LEFT : Direction.RIGHT;
        String direction = arg.get("DIRECTION", 0);
        if ("<".equals(direction)) {
            dir = Direction.LEFT;
        } else if (">".equals(direction)) {
            dir = Direction.RIGHT;
        }
        return diagram.addIdea(backColor, diagram.getSmartLevel(type), label, dir, IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }
}

