/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBoxOld;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.wbs.ITF;

class ITFLeaf
extends AbstractTextBlock
implements ITF {
    private final TextBlock box;

    public ITFLeaf(Style style, ISkinParam skinParam, Display label, IdeaShape shape) {
        if (shape == IdeaShape.BOX) {
            this.box = FtileBoxOld.createWbs(style, skinParam, label);
        } else {
            TextBlock text = label.create0(style.getFontConfiguration(skinParam.getIHtmlColorSet()), style.getHorizontalAlignment(), skinParam, style.wrapWidth(), CreoleMode.FULL, null, null);
            this.box = TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.box.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.box.drawU(ug);
    }

    @Override
    public XPoint2D getT1(StringBounder stringBounder) {
        XDimension2D dim = this.calculateDimension(stringBounder);
        return new XPoint2D(dim.getWidth() / 2.0, 0.0);
    }

    @Override
    public XPoint2D getT2(StringBounder stringBounder) {
        XDimension2D dim = this.calculateDimension(stringBounder);
        return new XPoint2D(dim.getWidth() / 2.0, dim.getHeight());
    }

    @Override
    public XPoint2D getF1(StringBounder stringBounder) {
        XDimension2D dim = this.calculateDimension(stringBounder);
        return new XPoint2D(0.0, dim.getHeight() / 2.0);
    }

    @Override
    public XPoint2D getF2(StringBounder stringBounder) {
        XDimension2D dim = this.calculateDimension(stringBounder);
        return new XPoint2D(dim.getWidth(), dim.getHeight() / 2.0);
    }
}

