/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc.dependencies;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.Set;
import java.util.stream.Collectors;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageDependency;

public class PackageDependencyCycle
extends AbstractList<PackageDependency>
implements RandomAccess {
    private final PackageDependency[] cycle;

    public PackageDependencyCycle(PackageDependency ... dependencies) {
        if (dependencies.length < 1) {
            throw new IllegalArgumentException("A dependency cycle may not be empty.");
        }
        this.cycle = dependencies;
        for (int i = 0; i < dependencies.length; ++i) {
            String to = dependencies[i].toPackage;
            String from = dependencies[(i + 1) % dependencies.length].fromPackage;
            if (to.equals(from)) continue;
            throw new IllegalArgumentException("Not a dependency cycle: '" + to + "' != '" + from + "': " + this);
        }
    }

    public static Set<PackageDependencyCycle> detectCycles(Iterable<PackageDependency> dependencies) {
        LinkedList<Object> chains = new LinkedList<Object>();
        for (PackageDependency dependency : dependencies) {
            ArrayList<PackageDependency[]> newChains = new ArrayList<PackageDependency[]>();
            for (PackageDependency[] packageDependencyArray : chains) {
                PackageDependency[] longerChain;
                if (!dependency.fromPackage.equals(PackageDependencyCycle.lastPackageName(packageDependencyArray)) || (longerChain = PackageDependencyCycle.growChain(packageDependencyArray, dependency)) == null) continue;
                newChains.add(longerChain);
            }
            chains.addAll(newChains);
            chains.add(new PackageDependency[]{dependency});
        }
        LinkedHashSet<PackageDependencyCycle> cycles = new LinkedHashSet<PackageDependencyCycle>();
        Iterator it = chains.iterator();
        while (it.hasNext()) {
            PackageDependency[] chain = (PackageDependency[])it.next();
            if (chain.length > 1 && chain[0].fromPackage.equals(PackageDependencyCycle.lastPackageName(chain))) {
                cycles.add(new PackageDependencyCycle(chain));
            }
            it.remove();
        }
        return cycles;
    }

    private static String lastPackageName(PackageDependency[] chain) {
        return chain.length == 0 ? null : chain[chain.length - 1].toPackage;
    }

    private static PackageDependency[] growChain(PackageDependency[] chain, PackageDependency dependency) {
        PackageDependency[] longerChain = new PackageDependency[chain.length + 1];
        for (int i = 0; i < chain.length; ++i) {
            if (dependency.equals(chain[i])) {
                return null;
            }
            longerChain[i] = chain[i];
        }
        longerChain[chain.length] = dependency;
        return longerChain;
    }

    @Override
    public PackageDependency get(int index) {
        return this.cycle[index];
    }

    @Override
    public int size() {
        return this.cycle.length;
    }

    @Override
    public String toString() {
        return this.cycle[0].fromPackage + " > " + this.stream().map(dep -> dep.toPackage).collect(Collectors.joining(" > "));
    }
}

