/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.Visibility;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public abstract class TypeMember
extends UMLNode {
    public final String name;
    public TypeName type;
    private Visibility visibility;
    public boolean isAbstract;
    public boolean isStatic;
    public boolean isDeprecated;

    protected TypeMember(Type containingType, String name, TypeName type) {
        super(containingType);
        this.name = Objects.requireNonNull(name, "Member name is <null>.").trim();
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("Member name is empty.");
        }
        this.type = type;
    }

    public Visibility getVisibility() {
        return this.visibility == null ? Visibility.PUBLIC : this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    protected <IPW extends IndentingPrintWriter> IPW writeTypeTo(IPW output) {
        if (this.type != null) {
            output.append(": ").append(this.type.toString());
        }
        return output;
    }

    void replaceParameterizedType(TypeName from, TypeName to) {
        if (from != null && from.equals(this.type)) {
            this.type = to;
        }
    }

    protected <IPW extends IndentingPrintWriter> IPW writeParametersTo(IPW output) {
        return output;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        if (this.isAbstract) {
            output.append("{abstract}").whitespace();
        }
        if (this.isStatic) {
            output.append("{static}").whitespace();
        }
        output.append(this.umlVisibility());
        if (this.isDeprecated) {
            output.append("--").append(this.name).append("--");
        } else {
            output.append(this.name);
        }
        this.writeParametersTo(output);
        this.writeTypeTo(output);
        output.newline();
        return output;
    }

    private String umlVisibility() {
        switch (this.getVisibility()) {
            case PRIVATE: {
                return "-";
            }
            case PROTECTED: {
                return "#";
            }
            case PACKAGE_PRIVATE: {
                return "~";
            }
        }
        return "+";
    }

    public int hashCode() {
        return Objects.hash(this.getParent(), this.name);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().equals(other.getClass()) && Objects.equals(this.getParent(), ((TypeMember)other).getParent()) && this.name.equals(((TypeMember)other).name);
    }
}

