/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.SmetanaForJson;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class JsonDiagram
extends TitledDiagram {
    private final JsonValue root;
    private final List<String> highlighted;

    public JsonDiagram(UmlSource source, UmlDiagramType type, JsonValue json, List<String> highlighted) {
        super(source, type, null);
        if (json != null && (json.isString() || json.isBoolean() || json.isNumber())) {
            this.root = new JsonArray();
            ((JsonArray)this.root).add(json);
        } else {
            this.root = json;
        }
        this.highlighted = highlighted;
    }

    @Override
    public DiagramDescription getDescription() {
        if (this.getUmlDiagramType() == UmlDiagramType.YAML) {
            return new DiagramDescription("(Yaml)");
        }
        if (this.getUmlDiagramType() == UmlDiagramType.HCL) {
            return new DiagramDescription("(HCL)");
        }
        return new DiagramDescription("(Json)");
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private void drawInternal(UGraphic ug) {
        if (this.root == null) {
            Display display = Display.getWithNewlines("Your data does not sound like " + this.getUmlDiagramType() + " data");
            FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.courier(14));
            TextBlock result = display.create(fontConfiguration, HorizontalAlignment.LEFT, this.getSkinParam());
            result = TextBlockUtils.withMargin(result, 5.0, 2.0);
            result.drawU(ug);
        } else {
            new SmetanaForJson(ug, this.getSkinParam()).drawMe(this.root, this.highlighted);
        }
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                JsonDiagram.this.drawInternal(ug);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return null;
            }

            @Override
            public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return TextBlockUtils.getMinMax(JsonDiagram.this.getTextBlock(), stringBounder, true).getDimension();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }
}

