/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.quantization;

import java.util.Collection;
import net.sourceforge.plantuml.quantization.Multiset;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public final class QColor {
    public static final QColor BLACK = new QColor(0.0, 0.0, 0.0);
    public static final QColor WHITE = new QColor(1.0, 1.0, 1.0);
    public static final QColor RED = new QColor(1.0, 0.0, 0.0);
    public static final QColor GREEN = new QColor(0.0, 1.0, 0.0);
    public static final QColor BLUE = new QColor(0.0, 0.0, 1.0);
    private final double red;
    private final double green;
    private final double blue;

    public QColor(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static QColor fromArgbInt(ColorMapper mapper, int rgb) {
        double alpha = (double)(rgb >>> 24 & 0xFF) / 255.0;
        double red = (double)(rgb >>> 16 & 0xFF) / 255.0;
        double green = (double)(rgb >>> 8 & 0xFF) / 255.0;
        double blue = (double)(rgb & 0xFF) / 255.0;
        if (mapper == ColorMapper.DARK_MODE) {
            red = alpha * red;
            green = alpha * green;
            blue = alpha * blue;
        } else {
            red = 1.0 - alpha * (1.0 - red);
            green = 1.0 - alpha * (1.0 - green);
            blue = 1.0 - alpha * (1.0 - blue);
        }
        return new QColor(red, green, blue);
    }

    public static QColor fromRgbInt(int rgb) {
        double red = (double)(rgb >>> 16 & 0xFF) / 255.0;
        double green = (double)(rgb >>> 8 & 0xFF) / 255.0;
        double blue = (double)(rgb & 0xFF) / 255.0;
        return new QColor(red, green, blue);
    }

    public static QColor getCentroid(Multiset<QColor> colors) {
        QColor sum = BLACK;
        for (QColor color : colors.getDistinctElements()) {
            int weight = colors.count(color);
            sum = sum.plus(color.scaled(weight));
        }
        return sum.scaled(1.0 / (double)colors.size());
    }

    public double getComponent(int index) {
        switch (index) {
            case 0: {
                return this.red;
            }
            case 1: {
                return this.green;
            }
            case 2: {
                return this.blue;
            }
        }
        throw new IllegalArgumentException("Unexpected component index: " + index);
    }

    public QColor scaled(double s) {
        return new QColor(s * this.red, s * this.green, s * this.blue);
    }

    public QColor plus(QColor that) {
        return new QColor(this.red + that.red, this.green + that.green, this.blue + that.blue);
    }

    public QColor minus(QColor that) {
        return new QColor(this.red - that.red, this.green - that.green, this.blue - that.blue);
    }

    public double getEuclideanDistanceTo(QColor that) {
        QColor d = this.minus(that);
        double sumOfSquares = d.red * d.red + d.green * d.green + d.blue * d.blue;
        return Math.sqrt(sumOfSquares);
    }

    public QColor getNearestColor(Collection<QColor> colors) {
        QColor nearestCentroid = null;
        double nearestCentroidDistance = Double.POSITIVE_INFINITY;
        for (QColor color : colors) {
            double distance = this.getEuclideanDistanceTo(color);
            if (!(distance < nearestCentroidDistance)) continue;
            nearestCentroid = color;
            nearestCentroidDistance = distance;
        }
        return nearestCentroid;
    }

    public int getRgbInt() {
        int redComponent = (int)(this.red * 255.0);
        int greenComponent = (int)(this.green * 255.0);
        int blueComponent = (int)(this.blue * 255.0);
        return redComponent << 16 | greenComponent << 8 | blueComponent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QColor)) {
            return false;
        }
        QColor that = (QColor)o;
        return this.red == that.red && this.green == that.green && this.blue == that.blue;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.red);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.green);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.blue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return String.format("Color[%f, %f, %f]", this.red, this.green, this.blue);
    }
}

