/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security.authentication.oauth;

import java.net.URLConnection;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.oauth.OAuth2Tokens;

public class OAuth2AccessInterceptor
implements SecurityAccessInterceptor {
    @Override
    public void apply(SecurityAuthentication authentication, URLConnection connection) {
        connection.setRequestProperty("Authorization", this.getAuth(authentication));
    }

    private String getAuth(SecurityAuthentication authentication) {
        String accessToken = (String)authentication.getTokens().get(OAuth2Tokens.ACCESS_TOKEN.key());
        String type = (String)authentication.getTokens().get(OAuth2Tokens.TOKEN_TYPE.key());
        return StringUtils.capitalize(type) + " " + accessToken;
    }
}

